/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.log;

import ch.qos.logback.classic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import net.shrine.log.Loggable;
import net.shrine.problem.RawProblem;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\t\u0013\u0001eAQ\u0001\n\u0001\u0005\u0002\u0015Bqa\n\u0001C\u0002\u0013\u0005\u0001\u0006\u0003\u00042\u0001\u0001\u0006I!\u000b\u0005\be\u0001\u0011\r\u0011\"\u00014\u0011\u00199\u0004\u0001)A\u0005i!)\u0001\b\u0001C\u0001s!)!\n\u0001C\u0001s!)q\n\u0001C\u0001s!)A\u000b\u0001C\u0001+\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007BB8\u0001A\u0003%!\u000eC\u0004q\u0001\t\u0007I\u0011A5\t\rE\u0004\u0001\u0015!\u0003k\u0011\u0015\u0011\b\u0001\"\u0001:\u0011\u00159\b\u0001\"\u0001:\u0011\u0015I\b\u0001\"\u0001:\u0005]\u0019Uo\u001d;p[B\u000bG\u000f^3s]2\u000b\u0017p\\;u)\u0016\u001cHO\u0003\u0002\u0014)\u0005\u0019An\\4\u000b\u0005U1\u0012AB:ie&tWMC\u0001\u0018\u0003\rqW\r^\u0002\u0001'\r\u0001!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"\u0001\n\n\u0005\r\u0012\"\u0001\u0003'pO\u001e\f'\r\\3\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0011\u0001\u0003\ryW\u000f^\u000b\u0002SA\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0003S>T\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t)\")\u001f;f\u0003J\u0014\u0018-_(viB,Ho\u0015;sK\u0006l\u0017\u0001B8vi\u0002\n1b\u001c:jO&t\u0017\r\\(viV\tA\u0007\u0005\u0002+k%\u0011ag\u000b\u0002\f!JLg\u000e^*ue\u0016\fW.\u0001\u0007pe&<\u0017N\\1m\u001fV$\b%A\u0006cK\u001a|'/Z\"mCN\u001cH#\u0001\u001e\u0011\u0005mY\u0014B\u0001\u001f\u001d\u0005\u0011)f.\u001b;)\u0005\u0019q\u0004CA I\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\u000bqA[;qSR,'O\u0003\u0002F\r\u0006)!.\u001e8ji*\tq)A\u0002pe\u001eL!!\u0013!\u0003\u0013\t+gm\u001c:f\u00032d\u0017!C1gi\u0016\u0014X)Y2iQ\t9A\n\u0005\u0002@\u001b&\u0011a\n\u0011\u0002\n\u0003\u001a$XM]#bG\"\f!\"\u00194uKJ\u001cE.Y:tQ\tA\u0011\u000b\u0005\u0002@%&\u00111\u000b\u0011\u0002\t\u0003\u001a$XM]!mY\u0006a1m\\;oi6\u000bGo\u00195fgR\u0019a+\u00174\u0011\u0005m9\u0016B\u0001-\u001d\u0005\rIe\u000e\u001e\u0005\u00065&\u0001\raW\u0001\nG>tG/Y5oKJ\u0004\"\u0001X2\u000f\u0005u\u000b\u0007C\u00010\u001d\u001b\u0005y&B\u00011\u0019\u0003\u0019a$o\\8u}%\u0011!\rH\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002c9!)q-\u0003a\u00017\u0006!a-\u001b8e\u0003II'G\u0019\u001aQCN\u001cxo\u001c:e'R\u0014\u0018N\\4\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\\\u0017\u0002\t1\fgnZ\u0005\u0003I2\f1#\u001b\u001aceA\u000b7o]<pe\u0012\u001cFO]5oO\u0002\n!$\u001a=qK\u000e$X\rZ%3EJ\u0002\u0016m]:x_J$7\u000b\u001e:j]\u001e\f1$\u001a=qK\u000e$X\rZ%3EJ\u0002\u0016m]:x_J$7\u000b\u001e:j]\u001e\u0004\u0013!\u0006;fgR\u001cUM\\:pe&\u0013$MM'fgN\fw-\u001a\u0015\u0003\u001dQ\u0004\"aP;\n\u0005Y\u0004%\u0001\u0002+fgR\fq\u0003^3ti\u000e+gn]8s\u0013J\u0012'\u0007\u00165s_^\f'\r\\3)\u0005=!\u0018\u0001\t;fgR\u001cUM\\:pe&\u0013$M\r+ie><\u0018M\u00197f/&$\bnQ1vg\u0016D#\u0001\u0005;)\u000b\u0001ax0!\u0001\u0011\u0005}j\u0018B\u0001@A\u00051!Vm\u001d;J]N$\u0018M\\2f\u0003\u00151\u0018\r\\;fI\t\t\u0019!\u0003\u0003\u0002\u0006\u0005\u001d\u0011!\u0003)F%~\u001bE*Q*T\u0015\u0011\tI!a\u0003\u0002\u00131Kg-Z2zG2,'bAA\u0007\u0001\u0006aA+Z:u\u0013:\u001cH/\u00198dK\u0002")
public class CustomPatternLayoutTest
implements Loggable {
    private final ByteArrayOutputStream out;
    private final PrintStream originalOut;
    private final String i2b2PasswordString;
    private final String expectedI2b2PasswordString;
    private Logger net$shrine$log$Loggable$$internalLogger;
    private volatile byte bitmap$init$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        CustomPatternLayoutTest customPatternLayoutTest = this;
        synchronized (customPatternLayoutTest) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                this.bitmap$0 = true;
            }
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        if (!this.bitmap$0) {
            return this.net$shrine$log$Loggable$$internalLogger$lzycompute();
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    public ByteArrayOutputStream out() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: CustomPatternLayoutTest.scala: 16");
        }
        return this.out;
    }

    public PrintStream originalOut() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: CustomPatternLayoutTest.scala: 17");
        }
        return this.originalOut;
    }

    @BeforeAll
    public void beforeClass() {
        System.setOut(new PrintStream(this.out()));
    }

    @AfterEach
    public void afterEach() {
        this.out().reset();
    }

    @AfterAll
    public void afterClass() {
        System.setOut(this.originalOut());
    }

    public int countMatches(String container, String find) {
        String tempString = container.replaceAll(find, "");
        return (container.length() - tempString.length()) / find.length();
    }

    public String i2b2PasswordString() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: CustomPatternLayoutTest.scala: 39");
        }
        return this.i2b2PasswordString;
    }

    public String expectedI2b2PasswordString() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: CustomPatternLayoutTest.scala: 40");
        }
        return this.expectedI2b2PasswordString;
    }

    @Test
    public void testCensorI2b2Message() {
        this.info((Function0<String>)(Function0 & Serializable)() -> this.i2b2PasswordString());
        String result = this.out().toString();
        Predef$.MODULE$.assert(result.contains(this.expectedI2b2PasswordString()));
        Assertions.assertEquals((int)this.countMatches(result, this.expectedI2b2PasswordString()), (int)1);
    }

    @Test
    public void testCensorI2b2Throwable() {
        IllegalArgumentException exception = new IllegalArgumentException(this.i2b2PasswordString());
        this.error((Function0<String>)(Function0 & Serializable)() -> "I2B2 sent back some strange xml", exception);
        String result = this.out().toString();
        Predef$.MODULE$.assert(result.contains(this.expectedI2b2PasswordString()));
        Assertions.assertEquals((int)this.countMatches(result, this.expectedI2b2PasswordString()), (int)1);
    }

    @Test
    public void testCensorI2b2ThrowableWithCause() {
        IllegalArgumentException exception = new IllegalArgumentException(this.i2b2PasswordString());
        exception.initCause(new RuntimeException(this.i2b2PasswordString()));
        this.error((Function0<String>)(Function0 & Serializable)() -> "I2B2 sent back some strange xml", exception);
        String result = this.out().toString();
        Assertions.assertEquals((int)this.countMatches(result, this.expectedI2b2PasswordString()), (int)2);
    }

    public CustomPatternLayoutTest() {
        Loggable.$init$((Loggable)this);
        this.out = new ByteArrayOutputStream();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.originalOut = System.out;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.i2b2PasswordString = "<password is_token=\"false\" token_ms_timeout=\"1800000\">kapow</password>";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.expectedI2b2PasswordString = "<password is_token=\"false\" token_ms_timeout=\"1800000\">REDACTED</password>";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

