/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.identity;

import org.apache.log4j.Logger;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.LazyIdentityService;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.NodeConfig;

public final class IdentityServiceFactory {
    static final Logger log = Logger.getLogger(IdentityServiceFactory.class);
    static final boolean INFO = log.isInfoEnabled();

    private IdentityServiceFactory() {
    }

    public static final IdentityService makeLazyIdentityService(NodeConfig config) {
        Util.guardNotNull((Object)config);
        Util.guardNotNull((Object)config.isAuthenticator());
        return new LazyIdentityService(config);
    }

    public static final IdentityService makeIdentityService(NodeConfig config) throws ConfigException {
        if (config == null) {
            throw new ConfigException("Null NodeConfig passed in");
        }
        if (config.getIdentityServiceClass() == null) {
            throw new ConfigException("Null identity service class name passed in");
        }
        try {
            return (IdentityService)ClassTools.createInstance((String)config.getIdentityServiceClass(), IdentityService.class);
        }
        catch (DynamicLoadingException e) {
            throw new ConfigException((Throwable)e);
        }
    }

    public static final IdentityService makeIdentityService() throws ConfigException {
        return IdentityServiceFactory.makeIdentityService(ConfigTool.loadNodeConfig());
    }
}

