/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.hive;

import edu.harvard.i2b2.crc.datavo.i2b2message.ApplicationType;
import edu.harvard.i2b2.crc.datavo.i2b2message.BodyType;
import edu.harvard.i2b2.crc.datavo.i2b2message.Constants;
import edu.harvard.i2b2.crc.datavo.i2b2message.FacilityType;
import edu.harvard.i2b2.crc.datavo.i2b2message.MessageHeaderType;
import edu.harvard.i2b2.crc.datavo.i2b2message.RequestHeaderType;
import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseHeaderType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResultStatusType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.i2b2message.StatusType;
import edu.harvard.i2b2.crc.datavo.pm.GetUserConfigurationType;
import edu.harvard.i2b2.crc.datavo.pm.ObjectFactory;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.shrine.serializers.hive.HiveJaxbContext;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.JAXBUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class HiveCommonSerializer {
    public static final Logger log = Logger.getLogger(HiveCommonSerializer.class);
    public static final boolean DEBUG = log.isDebugEnabled();
    public static final boolean INFO = log.isInfoEnabled();
    public static final String STATUS_ERROR = "ERROR";
    public static final String STATUS_DONE = "DONE";
    public static final String DONE = "DONE";
    public static final String ERROR = "ERROR";
    public static final String PENDING = "PENDING";

    public static final void addResponseHeaderWithDoneStatus(ResponseMessageType response) {
        response.setResponseHeader(new ResponseHeaderType(HiveCommonSerializer.getResultStatusDone("DONE")));
    }

    public static RequestMessageType getRequest(File xml) throws IOException, JAXBException {
        Object o = JAXBUtils.unmarshal((File)xml, (String)HiveJaxbContext.getInstance().getPackageList());
        return (RequestMessageType)((JAXBElement)o).getValue();
    }

    public static RequestMessageType getRequest(String xml) throws JAXBException {
        Object o = JAXBUtils.unmarshal((String)xml, (String)HiveJaxbContext.getInstance().getPackageList());
        return (RequestMessageType)((JAXBElement)o).getValue();
    }

    public static ResponseMessageType getResponse(File xml) throws IOException, JAXBException {
        Object o = JAXBUtils.unmarshal((File)xml, (String)HiveJaxbContext.getInstance().getPackageList());
        return (ResponseMessageType)((JAXBElement)o).getValue();
    }

    public static ResponseMessageType getResponse(String xml) throws JAXBException {
        Object o = JAXBUtils.unmarshal((Reader)new StringReader(xml), (String)HiveJaxbContext.getInstance().getPackageList());
        return (ResponseMessageType)((JAXBElement)o).getValue();
    }

    public static String toXMLString(RequestMessageType requestMessageType) throws JAXBException {
        Marshaller m = HiveJaxbContext.getInstance().getContext().createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal((Object)requestMessageType, (Writer)sw);
        return sw.toString();
    }

    public static String toXMLString(ResponseMessageType responseMessageType) throws JAXBException {
        Marshaller m = HiveJaxbContext.getInstance().getContext().createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal((Object)responseMessageType, (Writer)sw);
        return sw.toString();
    }

    public static RequestMessageType getTemplateRequestMessageType(SecurityType securityType, String projectId) {
        RequestMessageType request = HiveCommonSerializer.getTemplateRequestMessageType();
        request.getMessageHeader().setSecurity(securityType);
        request.getMessageHeader().setProjectId(projectId);
        return request;
    }

    public static ResponseMessageType getTemplateResponseMessageType(RequestMessageType requestMessageType) {
        ResponseMessageType response = new ResponseMessageType();
        response.setMessageHeader(requestMessageType.getMessageHeader());
        response.setMessageBody(new BodyType());
        return response;
    }

    public static ResponseMessageType getTemplateResponseMessageTypeError(RequestMessageType requestMessageType, String errorMessage) {
        ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType(requestMessageType);
        response.setResponseHeader(HiveCommonSerializer.getResponseHeaderError(errorMessage));
        return response;
    }

    protected static String getDefaultSendingApplicationVersion() {
        return "1.3-compatible";
    }

    protected static String getDefaultSendingApplicationName() {
        return "SHRINE";
    }

    protected static String getDefaultSendingFacilityName() {
        return "SHRINE";
    }

    public static String getPMGetAllUserParamsRequestString(SecurityType securityType) throws JAXBException {
        RequestMessageType request = HiveCommonSerializer.getTemplateRequestMessageType(securityType, "");
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement getAllUserParam = objectFactory.createGetAllUserParam("<username>" + securityType.getUsername() + "</username>");
        request.getMessageBody().getAny().add(getAllUserParam);
        return HiveCommonSerializer.toXMLString(request);
    }

    public static String getPMUserAuthRequestString(SecurityType securityType) throws JAXBException {
        RequestMessageType request = HiveCommonSerializer.getTemplateRequestMessageType(securityType, "");
        GetUserConfigurationType getUserConfiguration = new GetUserConfigurationType();
        getUserConfiguration.getProject().add("undefined");
        request.getMessageBody().getAny().add(getUserConfiguration);
        return HiveCommonSerializer.toXMLString(request);
    }

    public static SecurityType getSecurityType(RequestMessageType requestMessageType) {
        return requestMessageType.getMessageHeader().getSecurity();
    }

    public static SecurityType getSecurityType(ResponseMessageType responseMessageType) {
        return responseMessageType.getMessageHeader().getSecurity();
    }

    public static void setSecurityType(RequestMessageType requestMessageType, SecurityType credentials) {
        requestMessageType.getMessageHeader().setSecurity(credentials);
    }

    public static void setSecurityType(ResponseMessageType responseMessageType, SecurityType credentials) {
        responseMessageType.getMessageHeader().setSecurity(credentials);
    }

    public static Object getRequestBodyNodeObject(RequestMessageType request, int index) {
        Object o = request.getMessageBody().getAny().get(index);
        return o;
    }

    public static Object getResponseBodyNodeObject(ResponseMessageType response, int index) throws SerializationException {
        if (response.getMessageBody().getAny().size() == 0) {
            throw new SerializationException("Response contains no message body");
        }
        if (response.getMessageBody().getAny().size() < index) {
            throw new SerializationException("Response body size is smaller than requested");
        }
        return response.getMessageBody().getAny().get(index);
    }

    public static <T> T getBodyNode(ResponseMessageType response, int index, Class<T> clazz) throws SerializationException {
        Object o = HiveCommonSerializer.getResponseBodyNodeObject(response, index);
        return HiveCommonSerializer.tryToCast(o, clazz);
    }

    public static <T> T getBodyNode(RequestMessageType request, int index, Class<T> clazz) throws SerializationException {
        Object o = HiveCommonSerializer.getRequestBodyNodeObject(request, index);
        return HiveCommonSerializer.tryToCast(o, clazz);
    }

    private static <T> T tryToCast(Object o, Class<T> clazz) throws SerializationException {
        try {
            if (Node.class.isAssignableFrom(o.getClass())) {
                return (T)JAXBUtils.unmarshal((Node)((Node)o), clazz);
            }
            if (JAXBElement.class.isAssignableFrom(o.getClass())) {
                JAXBElement element = (JAXBElement)o;
                return clazz.cast(element.getValue());
            }
            return clazz.cast(o);
        }
        catch (Exception e) {
            throw new SerializationException("Conversion Failed between " + HiveCommonSerializer.getClassNameEvenIfWrapped(o) + " and " + String.valueOf(clazz), e);
        }
    }

    private static final String getClassNameEvenIfWrapped(Object o) {
        if (o == null) {
            return null;
        }
        if (JAXBElement.class.isAssignableFrom(o.getClass())) {
            JAXBElement element = (JAXBElement)o;
            return element.getValue().getClass().getName();
        }
        return o.getClass().getName();
    }

    public static <T> T getBodyNodeSingle(ResponseMessageType response, Class<T> clazz) throws SerializationException {
        return HiveCommonSerializer.getBodyNode(response, 0, clazz);
    }

    public static <T> T getBodyNodeSingle(RequestMessageType request, Class<T> clazz) throws SerializationException {
        return HiveCommonSerializer.getBodyNode(request, 0, clazz);
    }

    public static void clearBodyNode(RequestMessageType request) throws SerializationException {
        HiveCommonSerializer.clearBodyNode(request.getMessageBody());
    }

    public static void clearBodyNode(ResponseMessageType response) throws SerializationException {
        HiveCommonSerializer.clearBodyNode(response.getMessageBody());
    }

    public static void clearBodyNode(BodyType body) throws SerializationException {
        body.getAny().clear();
    }

    @Deprecated
    public static <T> void addBodyNode(ResponseMessageType response, T bodyNode) throws SerializationException {
        HiveCommonSerializer.addBodyNode(response, response.getMessageBody().getAny().size(), bodyNode);
    }

    @Deprecated
    public static <T> void addBodyNode(ResponseMessageType response, int index, T bodyNode) throws SerializationException {
        try {
            Element element = JAXBUtils.marshalToElement(bodyNode);
            response.getMessageBody().getAny().add(index, element);
        }
        catch (Exception e) {
            throw new SerializationException("could not add query result instance", e);
        }
    }

    @Deprecated
    public static <T> void updateBodyNode(ResponseMessageType response, int index, T bodyNode) throws SerializationException {
        response.getMessageBody().getAny().remove(index);
        response.getMessageBody().getAny().add(index, bodyNode);
    }

    @Deprecated
    public static <T> void addBodyNode(RequestMessageType request, T bodyNode) throws SerializationException {
        HiveCommonSerializer.addBodyNode(request, request.getMessageBody().getAny().size(), bodyNode);
    }

    @Deprecated
    public static <T> void addBodyNode(RequestMessageType request, int index, T bodyNode) throws SerializationException {
        try {
            Element element = JAXBUtils.marshalToElement(bodyNode);
            request.getMessageBody().getAny().add(index, element);
        }
        catch (Exception e) {
            throw new SerializationException("could not add query result instance", e);
        }
    }

    @Deprecated
    public static <T> void updateBodyNode(RequestMessageType request, int index, T bodyNode) throws SerializationException {
        try {
            Element bodyElement = JAXBUtils.marshalToElement(bodyNode);
            request.getMessageBody().getAny().remove(index);
            request.getMessageBody().getAny().add(index, bodyElement);
        }
        catch (Exception e) {
            throw new SerializationException("Failed to update body node", e);
        }
    }

    public static <T> void add(ResponseMessageType response, Class<T> clazz) throws SerializationException {
        try {
            Element element = JAXBUtils.marshalToElement(clazz);
            response.getMessageBody().getAny().add(element);
        }
        catch (Exception e) {
            throw new SerializationException("could not add query result instance", e);
        }
    }

    public static void stripLocalUserPassword(RequestMessageType request) {
        if (DEBUG) {
            log.debug((Object)"Stripping local user credentials before broadcasting the message.");
        }
        request.getMessageHeader().getSecurity().setPassword(null);
    }

    public static RequestMessageType getTemplateRequestMessageType() {
        RequestMessageType requestMessageType = new RequestMessageType();
        requestMessageType.setMessageHeader(HiveCommonSerializer.getTemplateMessageHeaderType());
        requestMessageType.setRequestHeader(HiveCommonSerializer.getTemplateRequestHeaderType());
        requestMessageType.setMessageBody(new BodyType());
        return requestMessageType;
    }

    public static MessageHeaderType getTemplateMessageHeaderType() {
        MessageHeaderType messageHeaderType = new MessageHeaderType();
        messageHeaderType.setSecurity(new SecurityType());
        messageHeaderType.setI2B2VersionCompatible(Constants.i2b2_version_compatible);
        messageHeaderType.setHl7VersionCompatible(Constants.hl7_version_compatible);
        ApplicationType appType = new ApplicationType();
        appType.setApplicationName(HiveCommonSerializer.getDefaultSendingApplicationName());
        appType.setApplicationVersion(HiveCommonSerializer.getDefaultSendingApplicationVersion());
        messageHeaderType.setSendingApplication(appType);
        FacilityType facilityType = new FacilityType();
        facilityType.setFacilityName(HiveCommonSerializer.getDefaultSendingFacilityName());
        messageHeaderType.setSendingFacility(facilityType);
        try {
            XMLGregorianCalendar xmlNow = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            messageHeaderType.setDatetimeOfMessage(xmlNow);
        }
        catch (DatatypeConfigurationException e) {
            log.error((Object)"Failed to generate Message Timestamp", (Throwable)e);
        }
        return messageHeaderType;
    }

    public static RequestHeaderType getTemplateRequestHeaderType() {
        RequestHeaderType requestHeaderType = new RequestHeaderType();
        return requestHeaderType;
    }

    public static ResponseHeaderType getResponseHeaderDone() {
        return new ResponseHeaderType(HiveCommonSerializer.getResultStatusDone(null));
    }

    public static ResponseHeaderType getResponseHeaderPending(String messageText) {
        return new ResponseHeaderType(HiveCommonSerializer.getResultStatusPending(messageText));
    }

    public static ResponseHeaderType getResponseHeaderError(String messageText) {
        return new ResponseHeaderType(HiveCommonSerializer.getResultStatusError(messageText));
    }

    public static ResultStatusType getResultStatusDone(String messageText) {
        return new ResultStatusType(new StatusType("DONE", messageText));
    }

    public static ResultStatusType getResultStatusError(String messageText) {
        return new ResultStatusType(new StatusType("ERROR", messageText));
    }

    public static ResultStatusType getResultStatusPending(String messageText) {
        return new ResultStatusType(new StatusType(PENDING, messageText));
    }

    public static StatusType getResponseStatusType(ResponseMessageType response) {
        try {
            return response.getResponseHeader().getResultStatus().getStatus();
        }
        catch (Exception e) {
            log.error((Object)"getResponseStatusType Failed!", (Throwable)e);
            return null;
        }
    }
}

