/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting$;
import scala.Function1;
import scala.Function7;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001i3\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\tA\u0001\u0004\u0003\u0019Q+7\u000f\u001e*feVtg.\u001a:\u000b\u0005\r!\u0011!C:dC2\fG/Z:u\u0015\u0005)\u0011aA8sON!\u0001aB\b\u0014!\tAQ\"D\u0001\n\u0015\tQ1\"\u0001\u0003mC:<'\"\u0001\u0007\u0002\t)\fg/Y\u0005\u0003\u001d%\u0011aa\u00142kK\u000e$\bC\u0001\t\u0012\u001b\u0005\u0011\u0011B\u0001\n\u0003\u0005!\u0011VM];o]\u0016\u0014\bC\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"aC*dC2\fwJ\u00196fGRD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u000fgVLG/Z\"mCN\u001ch*Y7f\u0007\u0001\u0001\"!\b\u0011\u000f\u0005Qq\u0012BA\u0010\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011E\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005})\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0011Q,7\u000f\u001e(b[\u0016DQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDc\u0001\u0015*UA\u0011\u0001\u0003\u0001\u0005\u00065\u0015\u0002\r\u0001\b\u0005\u0006I\u0015\u0002\r\u0001\b\u0005\u0006Y\u0001!\t!L\u0001\u0006CB\u0004H.\u001f\u000b\t]E24\b\u0011%Q+B\u0011AcL\u0005\u0003aU\u0011A!\u00168ji\")!g\u000ba\u0001g\u00051!/\u001a9peR\u0004\"\u0001\u0005\u001b\n\u0005U\u0012!\u0001\u0003*fa>\u0014H/\u001a:\t\u000b]Z\u0003\u0019\u0001\u001d\u0002\u000fM$x\u000e\u001d9feB\u0011\u0001#O\u0005\u0003u\t\u0011qa\u0015;paB,'\u000fC\u0003=W\u0001\u0007Q(\u0001\u0004gS2$XM\u001d\t\u0003!yJ!a\u0010\u0002\u0003\r\u0019KG\u000e^3s\u0011\u0015\t5\u00061\u0001C\u0003%\u0019wN\u001c4jO6\u000b\u0007\u000f\u0005\u0003\u001e\u0007r)\u0015B\u0001##\u0005\ri\u0015\r\u001d\t\u0003)\u0019K!aR\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003JW\u0001\u0007!*A\u0006eSN$(/\u001b2vi>\u0014\bc\u0001\u000bL\u001b&\u0011A*\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Aq\u0015BA(\u0003\u0005-!\u0015n\u001d;sS\n,Ho\u001c:\t\u000bE[\u0003\u0019\u0001*\u0002\u000fQ\u0014\u0018mY6feB\u0011\u0001cU\u0005\u0003)\n\u0011q\u0001\u0016:bG.,'\u000fC\u0003WW\u0001\u0007q+\u0001\u0004m_\u0006$WM\u001d\t\u0003\u0011aK!!W\u0005\u0003\u0017\rc\u0017m]:M_\u0006$WM\u001d")
public class TestRerunner
implements Rerunner,
ScalaObject {
    private final String suiteClassName;
    private final String testName;

    public String toString() {
        return Function7.class.toString((Function7)this);
    }

    public Function1 curried() {
        return Function7.class.curried((Function7)this);
    }

    public Function1 curry() {
        return Function7.class.curry((Function7)this);
    }

    public Function1 tupled() {
        return Function7.class.tupled((Function7)this);
    }

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter2, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        long runStartTime = System.currentTimeMillis();
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            report.apply(RunStarting$.MODULE$.apply(tracker.nextOrdinal(), 1, configMap));
            suite.run((Option<String>)new Some((Object)this.testName), report, stopper, filter2, configMap, distributor, tracker);
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunCompleted$.MODULE$.apply(tracker.nextOrdinal(), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(throwable), (Option<Throwable>)new Some((Object)throwable), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadClass", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noClassDefFoundError.getMessage()})), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (SecurityException securityException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("securityWhenRerruning", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{securityException.getMessage()})), (Option<Throwable>)new Some((Object)securityException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotFindMethod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noSuchMethodException.getMessage()})), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (IllegalAccessException illegalAccessException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{illegalAccessException.getMessage()})), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (InstantiationException instantiationException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{instantiationException.getMessage()})), (Option<Throwable>)new Some((Object)instantiationException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (ClassNotFoundException classNotFoundException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{classNotFoundException.getMessage()})), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
    }

    public TestRerunner(String suiteClassName, String testName) {
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        Function7.class.$init$((Function7)this);
        if (suiteClassName == null || testName == null) {
            throw new NullPointerException();
        }
    }
}

