/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.cache;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.log4j.Logger;
import org.spin.query.message.cache.Cache;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.EhcacheMemoryResultStore;
import org.spin.query.message.cache.QueryCompletionSignaller;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.cache.ReadOnlyResultStore;
import org.spin.query.message.cache.ResponseNode;
import org.spin.query.message.cache.ResultStore;
import org.spin.query.message.cache.RootResponseNode;
import org.spin.query.message.cache.SimpleInMemoryResultStore;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.Result;
import org.spin.query.message.headers.ResultSet;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.ResultStoreType;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.Signable;
import org.spin.tools.crypto.signature.XMLSignatureUtil;

public final class MemoryResidentCache
implements Cache {
    private static final Logger log = Logger.getLogger(MemoryResidentCache.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final XMLSignatureUtil xmlSignatureUtil;
    private final long maxAgeBeforeExpiration;
    private final CertID nodeID;
    final ResultStore resultStore;
    private final QueryCompletionSignaller signaller;

    public MemoryResidentCache(CertID nodeID, NodeConfig nodeConfig, QueryCompletionSignaller signaller) throws ConfigException {
        this(nodeConfig.getCacheTTL(), nodeConfig.getResultStoreType(), nodeID, XMLSignatureUtil.getDefaultInstance(), signaller);
    }

    MemoryResidentCache(long maxAgeBeforeExpiration, ResultStoreType resultStoreType, CertID nodeID, XMLSignatureUtil xmlSignatureUtil, QueryCompletionSignaller signaller) {
        Util.require((maxAgeBeforeExpiration > 0L ? 1 : 0) != 0);
        Util.guardNotNull((Object)nodeID);
        Util.guardNotNull((Object)resultStoreType);
        Util.guardNotNull((Object)xmlSignatureUtil);
        Util.guardNotNull((Object)signaller);
        this.maxAgeBeforeExpiration = maxAgeBeforeExpiration;
        this.nodeID = nodeID;
        this.xmlSignatureUtil = xmlSignatureUtil;
        this.signaller = signaller;
        switch (resultStoreType) {
            case Ehcache: {
                this.resultStore = new EhcacheMemoryResultStore();
                break;
            }
            default: {
                this.resultStore = new SimpleInMemoryResultStore();
            }
        }
    }

    public CertID getNodeID() {
        return this.nodeID;
    }

    @Override
    public void initQuery(QueryInfo queryInfo) {
        try {
            this.ensureRootResponseNode(queryInfo);
        }
        catch (CacheException e) {
            log.warn((Object)"Failed to initialize the query!", (Throwable)e);
        }
    }

    public void destroy() {
        this.resultStore.shutDownCache();
    }

    public boolean isDestroyed() {
        return this.resultStore.isCacheShutDown();
    }

    void onComplete(String queryID) {
        this.signaller.signalCompletionOf(queryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCacheExpiry() {
        ArrayList queriesToRemove = Util.makeArrayList();
        ResultStore resultStore = this.resultStore;
        synchronized (resultStore) {
            for (String queryID : this.resultStore.getStoredQueryIDs()) {
                try {
                    ResponseNode entry = this.getRootResponseNode(queryID);
                    if (!entry.isExpired(this.maxAgeBeforeExpiration)) continue;
                    if (INFO) {
                        log.info((Object)("Removing expired query: " + queryID + ", created on: " + entry.getTimestamp() + ", current time: " + Calendar.getInstance()));
                    }
                    queriesToRemove.add(queryID);
                }
                catch (QueryNotFoundException e) {
                    log.error((Object)("Error deleting expired query: " + queryID), (Throwable)e);
                }
            }
            for (String queryID : queriesToRemove) {
                this.resultStore.remove(queryID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(QueryInfo queryInfo, Result resultData) throws CacheException {
        try {
            String queryID = queryInfo.getQueryID();
            if (DEBUG) {
                log.debug((Object)("Setting reply for query: " + queryID));
                log.debug((Object)("Query results: " + resultData));
            }
            ResultStore resultStore = this.resultStore;
            synchronized (resultStore) {
                ResponseNode leafnode = this.updateTreeAndGetLeafNode(queryInfo);
                leafnode.setPayload(resultData);
            }
            if (this.isComplete(queryID)) {
                this.onComplete(queryID);
            }
        }
        finally {
            this.checkCacheExpiry();
        }
    }

    private ResponseNode updateTreeAndGetLeafNode(QueryInfo queryInfo) throws CacheException {
        ResponseNode rootNode = this.ensureRootResponseNode(queryInfo);
        return rootNode.updateTree(queryInfo);
    }

    private ResponseNode ensureRootResponseNode(QueryInfo queryInfo) throws CacheException {
        ResultStore resultStore = this.resultStore;
        synchronized (resultStore) {
            if (!this.resultStore.containsQueryID(queryInfo.getQueryID())) {
                RootResponseNode rootNode = new RootResponseNode(this.nodeID, queryInfo);
                this.resultStore.put(queryInfo.getQueryID(), rootNode);
                return rootNode;
            }
            try {
                return this.getRootResponseNode(queryInfo.getQueryID());
            }
            catch (QueryNotFoundException qnfe) {
                throw new CacheException(qnfe);
            }
        }
    }

    private ResponseNode getRootResponseNode(String queryID) throws QueryNotFoundException {
        RootResponseNode r = this.resultStore.get(queryID);
        if (r == null) {
            throw new QueryNotFoundException("Cannot find query: " + queryID);
        }
        return r;
    }

    @Override
    public ResultSet getResult(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.getResult(queryID, requestorID, true);
    }

    @Override
    public ResultSet getResultNoDelete(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.getResult(queryID, requestorID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getResult(String queryID, Identity requestorID, boolean deleteFromCache) throws CacheException, QueryNotFoundException {
        this.guardQueryIDIsPresent(queryID);
        this.guardQueryIDBelongsToRequestor(queryID, requestorID);
        this.guardIsAuthorizedRequestor(queryID, requestorID);
        try {
            if (INFO) {
                log.info((Object)("Getting result for queryID: " + queryID));
            }
            ResponseNode resultRoot = this.getRootResponseNode(queryID);
            Util.guardNotNull((Object)resultRoot);
            boolean complete = resultRoot.isComplete();
            if (complete && deleteFromCache) {
                ResultStore resultStore = this.resultStore;
                synchronized (resultStore) {
                    this.resultStore.remove(queryID);
                }
            }
            Collection<Result> results = resultRoot.toResults();
            ResultSet resultSet = ResultSet.of((String)queryID, (boolean)complete, (Integer)resultRoot.getExpectedResponses(), results);
            return resultSet;
        }
        finally {
            this.checkCacheExpiry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isComplete(String queryID) throws CacheException, QueryNotFoundException {
        this.guardQueryIDIsPresent(queryID);
        ResultStore resultStore = this.resultStore;
        synchronized (resultStore) {
            ResponseNode root = this.getRootResponseNode(queryID);
            return root.isComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countResponses(String queryID) throws QueryNotFoundException {
        this.guardQueryIDIsPresent(queryID);
        try {
            int numResponders;
            ResultStore resultStore = this.resultStore;
            synchronized (resultStore) {
                numResponders = this.getRootResponseNode(queryID).getNumResponses();
            }
            if (INFO) {
                log.info((Object)("countResponses: Found " + numResponders + " responders for query " + queryID));
            }
            int n = numResponders;
            return n;
        }
        finally {
            this.checkCacheExpiry();
        }
    }

    @Override
    public boolean hasUpdate(String queryID, int numResponders) throws CacheException, QueryNotFoundException {
        this.guardQueryIDIsPresent(queryID);
        return this.countResponses(queryID) > numResponders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) throws CacheException {
        Util.require((queryInfo != null ? 1 : 0) != 0);
        String queryID = queryInfo.getQueryID();
        Util.require((queryID != null ? 1 : 0) != 0);
        ResultStore resultStore = this.resultStore;
        synchronized (resultStore) {
            ResponseNode leafNode = this.updateTreeAndGetLeafNode(queryInfo);
            leafNode.expectResponse(queryInfo, statuses, numChildren);
        }
        if (this.isComplete(queryID)) {
            this.onComplete(queryID);
        }
    }

    private void guardQueryIDIsPresent(String queryID) throws QueryNotFoundException {
        boolean queryPresent = this.resultStore.containsQueryID(queryID);
        if (!queryPresent) {
            throw new QueryNotFoundException("Unknown Query: " + queryID);
        }
    }

    private void guardQueryIDBelongsToRequestor(String queryID, Identity requestorID) throws CacheException {
        String requestor;
        RootResponseNode root = this.resultStore.get(queryID);
        String owner = root.getIdentity().getUsername();
        if (owner.equalsIgnoreCase(requestor = requestorID.getUsername())) {
            if (DEBUG) {
                log.debug((Object)("queryID " + queryID + " indeed belongs to " + requestor));
            }
        } else {
            throw new CacheException("queryID " + queryID + " was issued by a different user, expected: " + owner);
        }
    }

    private void guardIsAuthorizedRequestor(String queryID, Identity requestorID) throws CacheException {
        boolean valid;
        Util.guardNotNull((Object)requestorID);
        try {
            valid = this.xmlSignatureUtil.verifySignature((Signable)requestorID);
        }
        catch (XMLSignatureException e) {
            throw new CacheException("Error validating signature for user '" + requestorID.getUsername() + "'; requested query " + queryID, e);
        }
        if (valid) {
            if (DEBUG) {
                log.debug((Object)("Signature was valid for queryId " + queryID));
            }
        } else {
            throw new CacheException("Signature was invalid for queryId " + queryID);
        }
    }

    public ReadOnlyResultStore getResultStore() {
        return this.resultStore;
    }
}

