/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.Result;
import org.spin.tools.Interval;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.signature.CertID;

class ResponseNode {
    private static final Logger log = Logger.getLogger(ResponseNode.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    protected static final CertID Anonymous = new CertID("-1", "Anon");
    volatile boolean waitingForExpectResponse = true;
    volatile boolean waitingForAggregate = true;
    private final CertID id;
    long timestamp;
    private NodePayload payload = NodePayload.EmptyPayload;
    protected final List<ResponseNode> children = Collections.synchronizedList(new ArrayList());

    public ResponseNode(CertID id) {
        this.id = id;
        this.updateTimestamp();
    }

    public static final ResponseNode anonymous() {
        return new ResponseNode(Anonymous);
    }

    public final boolean isAnonymous() {
        return Anonymous.equals((Object)this.id);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResponseNode getChild(CertID childID) {
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                if (!child.id.equals((Object)childID)) continue;
                return child;
            }
        }
        return null;
    }

    private final List<CertID> trimRoutedByRemovingCurrentNode(QueryInfo queryInfo) {
        List<CertID> trimmedRoutedByList = this.trimRoutedByList(queryInfo);
        if (trimmedRoutedByList == null || trimmedRoutedByList.isEmpty()) {
            return Util.makeArrayList((Collection)queryInfo.getRoutedByNodes());
        }
        if (this.id.equals((Object)trimmedRoutedByList.get(0))) {
            trimmedRoutedByList.remove(0);
        }
        return trimmedRoutedByList;
    }

    private final List<CertID> trimRoutedByList(QueryInfo queryInfo) {
        ArrayList path = Util.makeArrayList((Collection)queryInfo.getRoutedByNodes());
        for (int i = 0; i < path.size(); ++i) {
            CertID test = (CertID)path.get(i);
            if (!test.equals((Object)this.id)) continue;
            return path.subList(i, path.size());
        }
        return Util.makeArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResponseNode updateTree(QueryInfo queryInfo) throws CacheException {
        Util.guardNotNull((Object)queryInfo);
        List<CertID> trimmed = this.trimRoutedByRemovingCurrentNode(queryInfo);
        ResponseNode cursor = this;
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (CertID childID : trimmed) {
                ResponseNode child = cursor.getChild(childID);
                if (child == null) {
                    child = cursor.addChild(new ResponseNode(childID));
                }
                cursor = child;
            }
        }
        this.updateTimestamp();
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void ensurePlaceholderChildren(int desiredTotalNumberOfChildren) {
        if (desiredTotalNumberOfChildren < 0) {
            throw new IllegalArgumentException("desiredTotalNumberOfChildren cannot be negative");
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            int currentNumChildren = this.children.size();
            if (currentNumChildren == desiredTotalNumberOfChildren) {
                if (DEBUG) {
                    log.debug((Object)("Num Children same as desired: " + currentNumChildren + " / " + desiredTotalNumberOfChildren));
                }
                return;
            }
            if (desiredTotalNumberOfChildren < currentNumChildren) {
                if (DEBUG) {
                    log.debug((Object)("Num Children > desired: " + currentNumChildren + " / " + desiredTotalNumberOfChildren));
                }
                int howManyToRemove = Math.max(0, currentNumChildren - desiredTotalNumberOfChildren);
                for (int i = 0; i < howManyToRemove; ++i) {
                    this.children.remove(this.getChild(Anonymous));
                }
            } else {
                if (DEBUG) {
                    log.debug((Object)("Num Children < desired: " + currentNumChildren + " / " + desiredTotalNumberOfChildren));
                }
                int howManyToAdd = Math.max(0, desiredTotalNumberOfChildren - currentNumChildren);
                for (int i = 0; i < howManyToAdd; ++i) {
                    this.addChild();
                }
            }
        }
    }

    private ResponseNode addChild() {
        return this.addChild(new ResponseNode(Anonymous));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResponseNode addChild(ResponseNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child ResponseNode passed to ResponseNode.addChild()");
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            if (child.isAnonymous()) {
                this.children.add(child);
                return child;
            }
            if (!this.children.contains(child)) {
                ResponseNode toReUse = this.findFirstPlaceholderChild();
                if (toReUse != null) {
                    this.children.remove(toReUse);
                }
                this.children.add(child);
                return child;
            }
            log.warn((Object)("Duplicate Child: at " + this.id.getName() + ": " + child.id.getName() + " other children: " + ResponseNode.getDescriptions(this.children)));
            return this.getChild(child.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> getDescriptions(List<ResponseNode> children) {
        assert (children != null);
        ArrayList result = Util.makeArrayList((int)children.size());
        List<ResponseNode> list = children;
        synchronized (list) {
            for (ResponseNode responseNode : children) {
                result.add(responseNode.id.getName());
            }
        }
        return result;
    }

    protected final ResponseNode findFirstPlaceholderChild() {
        return this.getChild(Anonymous);
    }

    public final CertID getId() {
        return this.id;
    }

    public final NodePayload getPayload() {
        return this.payload;
    }

    public final void setPayload(Result payload) throws CacheException {
        if (this.resultMatchesNodeID(payload)) {
            throw new CacheException("Sanity check failed: payload is from " + payload.getOrigin() + " but this responseNode is for " + this.id);
        }
        this.setPayload(new NodePayload(payload));
    }

    private boolean resultMatchesNodeID(Result result) {
        return result != null && !result.getOrigin().equals((Object)this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPayload(NodePayload payload) {
        assert (payload != null);
        if (DEBUG) {
            log.debug((Object)("SetPayload for NODE: " + this.id.toString() + " = " + payload.getValue()));
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            this.waitingForAggregate = false;
        }
        this.payload = payload;
        this.updateTimestamp();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseNode other = (ResponseNode)obj;
        return !(this.id == null ? other.id != null : !this.id.equals((Object)other.id));
    }

    public final boolean isExpired(long maxAgeInMillis) {
        Util.require((maxAgeInMillis > 0L ? 1 : 0) != 0);
        long now = new GregorianCalendar().getTimeInMillis();
        long delta = 1000L;
        return this.getTimestamp() + maxAgeInMillis < now - 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isComplete() {
        List<ResponseNode> list = this.children;
        synchronized (list) {
            if (this.waitingForExpectResponse || this.waitingForAggregate) {
                return false;
            }
            for (ResponseNode child : this.children) {
                if (child.isComplete()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ResponseNode> getChildren() {
        List<ResponseNode> list = this.children;
        synchronized (list) {
            return this.children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNumResponses() {
        int count = 0;
        if (this.payload != NodePayload.EmptyPayload) {
            count = 1;
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                count += child.getNumResponses();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean areAnyChildrenUnknown() {
        if (this.waitingForAggregate || this.waitingForExpectResponse) {
            return true;
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                if (!child.isAnonymous()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Integer getExpectedResponses() {
        if (this.areAnyChildrenUnknown()) {
            if (INFO) {
                log.info((Object)"Some children are unknown, expected responses is therefore null.");
            }
            return null;
        }
        int count = 0;
        if (this.payload != NodePayload.EmptyPayload) {
            count = 1;
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                Integer expectedResponses = child.getExpectedResponses();
                if (expectedResponses == null) {
                    return null;
                }
                count += expectedResponses.intValue();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) {
        if (DEBUG) {
            log.debug((Object)("ExpectResponse for NODE: " + this.id.toString()));
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            this.waitingForExpectResponse = false;
            if (!statuses.contains((Object)StatusCode.QueryStarted)) {
                this.waitingForAggregate = false;
            }
            if (statuses.contains((Object)StatusCode.BroadcastStarted) || numChildren != this.children.size()) {
                this.ensurePlaceholderChildren(numChildren);
            }
        }
    }

    public final Collection<Result> toResults() {
        LinkedList results = Util.makeLinkedList();
        this.cacheEntryAddDataRecurse(results, 1);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheEntryAddDataRecurse(Collection<Result> accumulator, int level) {
        if (NodePayload.EmptyPayload != this.payload) {
            accumulator.add(this.payload.getValue());
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                child.cacheEntryAddDataRecurse(accumulator, level + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder accumulator = new StringBuilder();
        accumulator.append("\n");
        List<ResponseNode> list = this.children;
        synchronized (list) {
            ResponseNode.toStringHelper(this, 0, accumulator);
        }
        return accumulator.toString();
    }

    private static void toStringHelper(ResponseNode node, int indentLevel, StringBuilder accumulator) {
        if (indentLevel > 0) {
            accumulator.append('+');
            for (int i = 1; i < indentLevel; ++i) {
                accumulator.append('-');
            }
        }
        accumulator.append(node.getId()).append(" (").append(node.isAnonymous() ? "Anonymous" : (node.isComplete() ? "Complete" : "In-progress")).append(node.getPayload() == null || NodePayload.EmptyPayload.equals(node.getPayload()) ? " EMPTY" : " Has Results").append(")");
        accumulator.append(" (waiting for expectResponse? ").append(node.waitingForExpectResponse).append(" waiting for aggregate? ").append(node.waitingForAggregate).append(")\n");
        for (ResponseNode child : node.children) {
            ResponseNode.toStringHelper(child, indentLevel + 1, accumulator);
        }
    }

    public static final class NodePayload {
        protected static final Result EmptyPayloadValue = Result.Null;
        public static final NodePayload EmptyPayload = new NodePayload();
        private final Result value;

        private NodePayload() {
            this.value = EmptyPayloadValue;
        }

        protected NodePayload(String value, Interval executionTime) throws ConfigException {
            this.value = Result.of((String)value, (Interval)executionTime);
        }

        public NodePayload(Result value) {
            Util.require((!EmptyPayloadValue.equals((Object)value) ? 1 : 0) != 0);
            this.value = value;
        }

        public Result getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodePayload other = (NodePayload)obj;
            return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
        }
    }
}

