/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.spin.extension.config.MailToolConfig;
import org.spin.extension.config.URLConfig;
import org.spin.tools.JAXBUtils;
import org.spin.tools.JDBCTool;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.FileConfig;
import org.spin.tools.config.JDBCConfig;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.Module;
import org.spin.tools.filter.FileFilterTool;
import org.spin.tools.filter.XMLFileFilter;
import org.w3c.dom.Node;

public final class ConfigToolLegacyMethods {
    private static final Logger log = Logger.getLogger(ConfigToolLegacyMethods.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();

    private ConfigToolLegacyMethods() {
    }

    public static final MailToolConfig loadMailToolConfig() throws ConfigException {
        return (MailToolConfig)ConfigTool.load((Module)Module.mail, MailToolConfig.class);
    }

    public static final void writeMailToolConfig(MailToolConfig config) throws ConfigException {
        ConfigTool.write((Module)Module.mail, (Object)config);
    }

    public static URL getURL(Node urlConfig) throws ConfigException {
        try {
            return ConfigToolLegacyMethods.getURL((URLConfig)JAXBUtils.unmarshalAndValidate((Node)urlConfig, URLConfig.class));
        }
        catch (JAXBException e) {
            throw new ConfigException("Could not parse URL", (Throwable)e);
        }
    }

    public static URL getURL(URLConfig urlConfig) throws ConfigException {
        try {
            return new URL(urlConfig.getUrl());
        }
        catch (MalformedURLException e) {
            throw new ConfigException("Malformed URL", (Throwable)e);
        }
    }

    public boolean isValid(FileConfig fileConfig) {
        return this.isValid(new File(fileConfig.getFilename()));
    }

    public boolean isValid(File file) {
        try {
            if (file.exists()) {
                log.debug((Object)("Found " + file.getAbsolutePath()));
                return true;
            }
            log.debug((Object)("File not found! " + file.getAbsolutePath()));
            return false;
        }
        catch (Exception e) {
            log.debug((Object)"Invalid file specified");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(JDBCConfig jdbc) {
        Connection conn = null;
        try {
            conn = JDBCTool.getConnection((JDBCConfig)jdbc);
            if (DEBUG) {
                log.debug((Object)"Test Connection successfull ! ");
                log.debug((Object)("driver=" + jdbc.getDriver()));
                log.debug((Object)("URL=" + jdbc.getUrl()));
                log.debug((Object)("username=" + jdbc.getUsername()));
                log.debug((Object)("password=" + jdbc.getPassword()));
            }
            boolean bl = true;
            return bl;
        }
        catch (ConfigException e) {
            log.debug((Object)"Test Connection FAILED!");
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException eaten) {}
            }
        }
    }

    public boolean isValid(KeyStoreConfig keystore) {
        try {
            log.warn((Object)"Currently have no way to test the keystore without reloading it application wide.");
            return true;
        }
        catch (Exception e) {
            log.warn((Object)"Could not load keystore !");
            return false;
        }
    }

    public boolean isValid(URLConfig url) {
        try {
            new URL(url.getUrl());
            if (DEBUG) {
                log.debug((Object)"URL is well formed.");
            }
            return true;
        }
        catch (MalformedURLException e) {
            log.warn((Object)"Malformed URL!");
            return false;
        }
    }

    public static Connection getConnection(File jdbcConfig) throws ConfigException {
        try {
            return JDBCTool.getConnection((JDBCConfig)((JDBCConfig)JAXBUtils.unmarshalAndValidate((File)jdbcConfig, JDBCConfig.class)));
        }
        catch (Exception e) {
            throw new ConfigException("Could not configure JDBC connection", (Throwable)e);
        }
    }

    public static Connection getConnection(Node jdbcConfig) throws ConfigException {
        try {
            return JDBCTool.getConnection((JDBCConfig)((JDBCConfig)JAXBUtils.unmarshalAndValidate((Node)jdbcConfig, JDBCConfig.class)));
        }
        catch (JAXBException e) {
            throw new ConfigException("Could not configure JDBC connection", (Throwable)e);
        }
    }

    public static File[] getXMLFiles(Node fileConfig) throws ConfigException {
        return ConfigToolLegacyMethods.getXMLFiles(ConfigToolLegacyMethods.getFileURL(fileConfig));
    }

    public static File[] getXMLFiles(FileConfig fileConfig) throws ConfigException {
        return ConfigToolLegacyMethods.getXMLFiles(ConfigToolLegacyMethods.getFileURL(fileConfig));
    }

    public static File[] getXMLFiles(File folder) throws ConfigException {
        try {
            return FileFilterTool.recursiveFilter((File)folder, (FileFilter)new XMLFileFilter());
        }
        catch (Exception e) {
            throw new ConfigException("Failed to get XML Files", (Throwable)e);
        }
    }

    public static File getFileURL(Node fileConfig) throws ConfigException {
        try {
            return ConfigToolLegacyMethods.getFileURL((FileConfig)JAXBUtils.unmarshalAndValidate((Node)fileConfig, FileConfig.class));
        }
        catch (JAXBException e) {
            throw new ConfigException("Could not find file resource", (Throwable)e);
        }
    }

    public static File getFileURL(FileConfig fileConfig) throws ConfigException {
        try {
            return new File(fileConfig.getFilename());
        }
        catch (Exception e) {
            throw new ConfigException("Could not find file resource " + fileConfig.getFilename(), (Throwable)e);
        }
    }
}

