/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension.codebook;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.spin.extension.codebook.CodebookEntry;
import org.spin.extension.codebook.CodebookException;
import org.spin.extension.codebook.CodebookIbatisTool;

public class Codebook {
    private static final Logger log = Logger.getLogger(Codebook.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private final SqlMapClient sqlMap = CodebookIbatisTool.Instance.getSqlMapClient();

    public Codebook() {
    }

    public Codebook(String codebookName) {
        this();
    }

    public Codebook(URL codebookConfigFile) {
        this();
    }

    public boolean exists(String key, String value) throws CodebookException {
        return this.getFirst(key, value) != null;
    }

    public boolean codebookIDExists(String codebookID) throws CodebookException {
        return this.exists(Key.codebookID.name(), codebookID);
    }

    public boolean UUIDExists(String UUID) throws CodebookException {
        return this.exists(Key.UUID.name(), UUID);
    }

    public boolean MRNExists(String MRN) throws CodebookException {
        return this.exists(Key.MRN.name(), MRN);
    }

    public List<CodebookEntry> get(String column, String value) throws CodebookException {
        List codebookEntries;
        try {
            HashMap<String, String> colval = new HashMap<String, String>();
            colval.put("column", column);
            colval.put("value", value);
            codebookEntries = this.sqlMap.queryForList("CodebookEntry.selectCodebookEntryListByCol", colval);
        }
        catch (SQLException e) {
            throw new CodebookException(e);
        }
        return codebookEntries;
    }

    public CodebookEntry getFirst(String column, String value) throws CodebookException {
        List<CodebookEntry> entries = this.get(column, value);
        return entries.size() == 0 ? null : entries.get(0);
    }

    public CodebookEntry getByCodebookID(String codebookID) throws CodebookException {
        return this.getFirst(Key.codebookID.name(), codebookID);
    }

    public CodebookEntry getByUUID(String deidentifiedUUID) throws CodebookException {
        return this.getFirst(Key.UUID.name(), deidentifiedUUID);
    }

    public List<CodebookEntry> getByMRN(String MRN) throws CodebookException {
        return this.get(Key.MRN.name(), MRN);
    }

    public List<CodebookEntry> getAll() throws CodebookException {
        List codebookEntries;
        try {
            codebookEntries = this.sqlMap.queryForList("CodebookEntry.selectCodebookEntryListAll");
        }
        catch (SQLException e) {
            throw new CodebookException(e);
        }
        return codebookEntries;
    }

    public void create(CodebookEntry entry) throws CodebookException {
        this.createOrUpdate(entry);
    }

    public void update(CodebookEntry entry) throws CodebookException {
        this.createOrUpdate(entry);
    }

    public void createOrUpdate(CodebookEntry entry) throws CodebookException {
        try {
            this.sqlMap.startTransaction();
            CodebookEntry codebookEntry = (CodebookEntry)this.sqlMap.queryForObject("CodebookEntry.selectCodebookEntry", (Object)entry.getCodebookID());
            if (codebookEntry == null) {
                this.sqlMap.insert("CodebookEntry.insertCodebookEntry", (Object)entry);
            } else {
                this.sqlMap.update("CodebookEntry.updateCodebookEntry", (Object)entry);
            }
            this.sqlMap.commitTransaction();
        }
        catch (SQLException e) {
            throw new CodebookException("Could not create or update codebook entry", e);
        }
        finally {
            try {
                this.sqlMap.endTransaction();
            }
            catch (SQLException e) {
                throw new CodebookException(e);
            }
        }
    }

    public void remove(String codebookId) throws CodebookException {
        try {
            this.sqlMap.startTransaction();
            this.sqlMap.delete("CodebookEntry.deleteCodebookEntry", (Object)codebookId);
            this.sqlMap.commitTransaction();
        }
        catch (SQLException e) {
            throw new CodebookException("Could not remove codebook entry", e);
        }
        finally {
            try {
                this.sqlMap.endTransaction();
            }
            catch (SQLException e) {
                throw new CodebookException(e);
            }
        }
    }

    public void remove(CodebookEntry entry) throws CodebookException {
        this.remove(entry.getCodebookID());
    }

    private static enum Key {
        MRN,
        codebookID,
        UUID;

    }
}

