/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension.codebook;

import com.ibatis.common.logging.LogFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.spin.tools.FileUtils;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;

public final class CodebookIbatisTool {
    public static final String sqlMapConfigFileName = "SqlMapConfig.xml";
    public static final String sqlMapPropertiesFileName = "SqlMapConfig.properties";
    public static final String sqlMapCodebookEntryTableCreateFileName = "spin-ibatis-codebookentry-create.sql";
    private static final Logger log = Logger.getLogger(CodebookIbatisTool.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final SqlMapClient sqlMap;
    private final String dbDriver;
    private final String dbUrl;
    private final String dbUsername;
    private final String dbPassword;
    public static final CodebookIbatisTool Instance = new CodebookIbatisTool();

    private CodebookIbatisTool() {
        this.addShutdownHook();
        LogFactory.selectLog4JLogging();
        try {
            URL configFile = this.getConfigFileURL();
            if (DEBUG) {
                log.debug((Object)("Initializing iBATIS with '" + configFile.getFile() + "'"));
            }
            Properties configProperties = this.loadPropertiesFile();
            this.dbDriver = configProperties.getProperty("db_driver");
            this.dbUrl = configProperties.getProperty("db_url");
            this.dbUsername = configProperties.getProperty("db_username");
            this.dbPassword = configProperties.getProperty("db_password");
            System.setProperty("derby.stream.error.file", configProperties.getProperty("derby.stream.error.file"));
            this.createSchemaIfNotExists();
            this.sqlMap = this.makeSQLMap(configProperties);
        }
        catch (Exception e) {
            log.error((Object)("Initial SqlMapClient creation failed: " + e.getMessage()));
            throw new ExceptionInInitializerError(e);
        }
    }

    private URL getConfigFileURL() {
        return ConfigTool.getClasspathResourceAsURL((String)sqlMapConfigFileName);
    }

    private SqlMapClient makeSQLMap(Properties configProperties) throws IOException {
        Reader sqlMapReader = Resources.getResourceAsReader((String)sqlMapConfigFileName);
        return SqlMapClientBuilder.buildSqlMapClient((Reader)sqlMapReader, (Properties)configProperties);
    }

    private Properties loadPropertiesFile() throws IOException, ConfigException {
        return ConfigTool.getProperties((InputStream)ConfigTool.getConfigFileStream((String)sqlMapPropertiesFileName));
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CodebookIbatisTool.this.shutDown();
                }
                catch (Exception e) {
                    log.error((Object)"Failed shutting down Spin codebook DB - this app may take longer to start up next time, or the codebook database may be corrupted: ", (Throwable)e);
                }
            }
        }));
    }

    public final SqlMapClient getSqlMapClient() {
        return this.sqlMap;
    }

    public final String getDbDriver() {
        return this.dbDriver;
    }

    public final String getDbUrl() {
        return this.dbUrl;
    }

    public final String getDbUsername() {
        return this.dbUsername;
    }

    private final String getDbPassword() {
        return this.dbPassword;
    }

    public final boolean shutDown() {
        return this.shutdownDerby();
    }

    private boolean shutdownDerby() {
        try {
            this.getDBDriverClass();
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            log.error((Object)"Failed shutting down Spin admin database");
            return false;
        }
        catch (SQLException e) {
            if (INFO) {
                log.info((Object)"Successfully shut down Spin admin database");
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Failed shutting down Spin admin database", (Throwable)e);
            return false;
        }
    }

    private Class<?> getDBDriverClass() throws ClassNotFoundException {
        return Class.forName(this.getDbDriver());
    }

    private void createSchemaIfNotExists() throws Exception {
        this.getDBDriverClass().newInstance();
        String createLogEntryTable = FileUtils.read((InputStream)ConfigTool.getClasspathResource((String)sqlMapCodebookEntryTableCreateFileName));
        this.exectuteIgnoringErrors(createLogEntryTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void exectuteIgnoringErrors(String sql) {
        Connection conn;
        block4: {
            Util.guardNotNull((Object)sql);
            conn = null;
            try {
                conn = DriverManager.getConnection(this.getDbUrl(), this.getDbUsername(), this.getDbPassword());
                if (conn == null) break block4;
                conn.createStatement().executeUpdate(sql);
            }
            catch (SQLException sQLException) {
                CodebookIbatisTool.close(conn);
                catch (Throwable throwable) {
                    CodebookIbatisTool.close(conn);
                    throw throwable;
                }
            }
        }
        CodebookIbatisTool.close(conn);
    }

    private static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.warn((Object)"Couldn't close connection; this is probably bad ", (Throwable)e);
        }
    }
}

