/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension.workarounds;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.spin.tools.JAXBUtils;
import org.xml.sax.ContentHandler;

public final class XMLWorkarounds {
    private static final Logger log = Logger.getLogger(JAXBUtils.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();

    private XMLWorkarounds() {
    }

    private static final XMLSerializer getXMLSerializer(Writer writer, String[] CDATAElements) {
        return new XMLSerializer(writer, XMLWorkarounds.makeOutputFormat(CDATAElements));
    }

    private static final OutputFormat makeOutputFormat(String[] CDATAElements) {
        OutputFormat result = new OutputFormat();
        result.setCDataElements(CDATAElements);
        result.setPreserveSpace(true);
        result.setIndenting(true);
        return result;
    }

    public static ContentHandler getContentHandler(File file, String[] CDATAElements) throws JAXBException {
        try {
            return XMLWorkarounds.getContentHandler(new FileWriter(file), CDATAElements);
        }
        catch (Exception e) {
            log.error((Object)"Failed to open content handler: ", (Throwable)e);
            throw new JAXBException((Throwable)e);
        }
    }

    public static ContentHandler getContentHandler(Writer writer, String[] CDATAElements) throws JAXBException {
        try {
            return XMLWorkarounds.getXMLSerializer(writer, CDATAElements).asContentHandler();
        }
        catch (IOException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void marshalToWriter(Object object, Writer writer, String[] cdataElements) throws JAXBException {
        assert (cdataElements != null);
        if (cdataElements.length > 0) {
            Marshaller marshaller = JAXBUtils.getMarshaller((Class[])new Class[]{object.getClass()});
            ContentHandler contentHandler = XMLWorkarounds.getContentHandler(writer, cdataElements);
            Marshaller marshaller2 = marshaller;
            synchronized (marshaller2) {
                marshaller.marshal(object, contentHandler);
            }
        } else {
            JAXBUtils.marshalToWriter((Object)object, (Writer)writer);
        }
    }

    public static final String marshalToString(Object object, String[] cdataElements) throws JAXBException {
        StringWriter result = new StringWriter();
        XMLWorkarounds.marshalToWriter(object, result, cdataElements);
        return result.toString();
    }
}

