/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.core.type.MethodMetadata;

final class ConfigurationClassMethod {
    private final MethodMetadata metadata;
    private final ConfigurationClass configurationClass;

    public ConfigurationClassMethod(MethodMetadata metadata, ConfigurationClass configurationClass) {
        this.metadata = metadata;
        this.configurationClass = configurationClass;
    }

    public MethodMetadata getMetadata() {
        return this.metadata;
    }

    public ConfigurationClass getConfigurationClass() {
        return this.configurationClass;
    }

    public Location getResourceLocation() {
        return new Location(this.configurationClass.getResource(), (Object)this.metadata);
    }

    public void validate(ProblemReporter problemReporter) {
        if (this.configurationClass.getMetadata().isAnnotated(Configuration.class.getName()) && !this.getMetadata().isOverridable()) {
            problemReporter.error((Problem)new NonOverridableMethodError());
        }
    }

    public String toString() {
        return String.format("[%s:name=%s,declaringClass=%s]", this.getClass().getSimpleName(), this.getMetadata().getMethodName(), this.getMetadata().getDeclaringClassName());
    }

    private class NonOverridableMethodError
    extends Problem {
        public NonOverridableMethodError() {
            super(String.format("Method '%s' must not be private, final or static; change the method's modifiers to continue", ConfigurationClassMethod.this.getMetadata().getMethodName()), ConfigurationClassMethod.this.getResourceLocation());
        }
    }
}

