/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import java.net.URL;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.SpinNode;
import org.spin.node.acknack.AckNack;
import org.spin.node.actions.QueryException;
import org.spin.node.actions.QuerySubmissionException;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.SpinAgent;
import org.spin.query.message.agent.TimeoutException;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.headers.EncryptionParams;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.QueryInput;
import org.spin.query.message.headers.ResultSet;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.query.message.serializer.BasicSerializer;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.PKITool;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;

public final class Agent
implements SpinAgent {
    private static final Logger log = Logger.getLogger(Agent.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private final AgentConfig agentConfig;
    private final SpinNode spinNode;

    public Agent() throws ConfigException, NodeException {
        this(ConfigTool.loadAgentConfig());
    }

    public Agent(AgentConfig agentConfig) throws ConfigException, NodeException {
        this(agentConfig, (SpinNode)NodeConnector.instance((String)agentConfig.getNodeConnectorEndpoint().getAddress()));
    }

    public Agent(AgentConfig agentConfig, URL nodeWsdlURL) throws ConfigException, NodeException {
        this(agentConfig, (SpinNode)NodeConnector.instance((URL)nodeWsdlURL));
    }

    public Agent(AgentConfig agentConfig, SpinNode spinNode) throws ConfigException {
        if (agentConfig == null) {
            throw new ConfigException("Null AgentConfig passed in");
        }
        if (spinNode == null) {
            throw new ConfigException("Null SpinNode passed in");
        }
        this.agentConfig = agentConfig;
        this.spinNode = spinNode;
        if (INFO) {
            log.info((Object)"Initialized Agent");
        }
    }

    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public Identity certify(String username, String password, String role) throws IdentityServiceException {
        return this.spinNode.certify(username, password, role);
    }

    /*
     * Exception decompiling
     */
    @Override
    public AckNack send(QueryInfo queryInfo, Object conditions) throws SerializationException, AgentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public AckNack send(QueryInfo queryInfo, Object conditions, CertID recipient) throws SerializationException, AgentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <Conditions> AckNack send(QueryInfo queryInfo, Conditions conditions, BasicSerializer<Conditions> serializer) throws SerializationException, AgentException {
        PKITool pkiTool;
        Util.guardNotNull((Object)queryInfo);
        Util.guardNotNull(serializer);
        try {
            pkiTool = PKITool.getInstance();
        }
        catch (ConfigException e) {
            throw new AgentException(e);
        }
        return this.send(queryInfo, conditions, serializer, pkiTool.getMyCertID());
    }

    @Override
    public <Conditions> AckNack send(QueryInfo queryInfo, Conditions conditions, BasicSerializer<Conditions> serializer, CertID recipient) throws SerializationException, AgentException {
        Util.guardNotNull((Object)queryInfo);
        Util.guardNotNull(serializer);
        return this.send(queryInfo, serializer.toString(conditions), recipient);
    }

    @Override
    public AckNack send(QueryInfo queryInfo, String conditions) throws AgentException {
        PKITool pkiTool;
        Util.guardNotNull((Object)queryInfo);
        try {
            pkiTool = PKITool.getInstance();
        }
        catch (ConfigException e) {
            throw new AgentException(e);
        }
        return this.send(queryInfo, conditions, pkiTool.getMyCertID());
    }

    @Override
    public AckNack send(QueryInfo queryInfo, String conditions, CertID recipient) throws AgentException {
        Util.guardNotNull((Object)queryInfo);
        EncryptionParams cryptoParams = Agent.makeEncryptionParamsFor(recipient);
        QueryInput queryInput = QueryInput.of((String)conditions, (EncryptionParams)cryptoParams);
        return this.send(this.setupQueryInfo(queryInfo), queryInput);
    }

    static EncryptionParams makeEncryptionParamsFor(CertID recipient) {
        return recipient == null ? EncryptionParams.NoEncryption : EncryptionParams.encryptFor((CertID)recipient);
    }

    @Override
    public AckNack send(QueryInfo queryInfo, QueryInput queryInput) throws AgentException, QueryException {
        AckNack result = this.spinNode.query(queryInfo, queryInput);
        if (INFO) {
            log.info((Object)("Sent query " + result.getQueryID() + ". Node response: " + result.getStatuses()));
        }
        if (result == null) {
            throw new QuerySubmissionException(null, "Null response received from node after submitting query " + queryInfo.getQueryID());
        }
        if (result.isError()) {
            throw new QuerySubmissionException(result, "Query " + result.getQueryID() + " failed; node responded with " + result.getStatuses() + " (Sent to peer group '" + this.agentConfig.getPeerGroupToQuery() + "')");
        }
        return result;
    }

    QueryInfo addDefaultPeerGroup(QueryInfo queryInfo) {
        if (queryInfo.getPeerGroup() == null) {
            return queryInfo.withPeerGroup(this.agentConfig.getPeerGroupToQuery());
        }
        return queryInfo;
    }

    QueryInfo addDefaultAggregatorEndpoint(QueryInfo queryInfo) {
        if (queryInfo.getAggregator() == null) {
            return queryInfo.withAggregator(this.agentConfig.getRootAggregatorEndpoint());
        }
        return queryInfo;
    }

    QueryInfo setupQueryInfo(QueryInfo queryInfo) {
        return this.addDefaultPeerGroup(this.addDefaultAggregatorEndpoint(queryInfo));
    }

    public QueryInfo getDefaultQueryInfo(String queryType) {
        return new QueryInfo(this.agentConfig.getPeerGroupToQuery(), null, queryType, this.agentConfig.getRootAggregatorEndpoint());
    }

    @Override
    public ResultSet receive(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.receive(queryID, requestorID, this.agentConfig.getMaxWaitTime());
    }

    @Override
    public ResultSet receive(String queryID, Identity requestorID, long waitTime) throws CacheException, QueryNotFoundException {
        return this.receive(queryID, requestorID, waitTime, null);
    }

    @Override
    public ResultSet receive(String queryID, Identity requestorID, long waitTime, Integer numExpectedResponses) throws CacheException, TimeoutException, QueryNotFoundException {
        if (DEBUG) {
            log.debug((Object)("Agent receiving query " + queryID));
        }
        this.waitForQueryToComplete(queryID, waitTime, numExpectedResponses);
        return this.getResult(queryID, requestorID);
    }

    @Override
    public void waitForQueryToComplete(String queryID, long maxWaitTime, Integer numExpectedResponses) throws CacheException, QueryNotFoundException, TimeoutException {
        long sleepTime = this.computeWaitTime();
        if (DEBUG) {
            log.debug((Object)("Agent waiting " + sleepTime + "ms between polling attempts"));
        }
        long timeToStopWaiting = System.currentTimeMillis() + maxWaitTime;
        while (this.queryIsNotComplete(queryID, numExpectedResponses)) {
            this.checkForTimeout(queryID, maxWaitTime, timeToStopWaiting);
            this.sleepFor(sleepTime);
        }
    }

    private final void checkForTimeout(String queryID, long waitTime, long timeToStopWaiting) throws CacheException, TimeoutException {
        if (System.currentTimeMillis() > timeToStopWaiting) {
            throw new TimeoutException("Could not complete query " + queryID + " in " + waitTime + " (ms)");
        }
    }

    private final void sleepFor(long sleepTime) throws CacheException {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted while trying to receive", (Throwable)e);
        }
    }

    final boolean queryIsNotComplete(String queryID, Integer numExpectedResponses) throws CacheException, QueryNotFoundException {
        return Agent.notSpecified(numExpectedResponses) ? !this.isComplete(queryID) : this.countResponders(queryID) < numExpectedResponses;
    }

    static final boolean notSpecified(Integer numExpectedResponses) {
        return numExpectedResponses == null;
    }

    final long computeWaitTime() {
        return (long)(1.0f / this.getPollingFrequency() * 1000.0f);
    }

    final float getPollingFrequency() {
        return (this.agentConfig.getPollingFrequency() != null ? this.agentConfig.getPollingFrequency() : AgentConfig.defaultPollingFrequency).floatValue();
    }

    @Override
    public ResultSet getResult(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        if (DEBUG) {
            log.debug((Object)("Getting results (and deleting) for query " + queryID));
        }
        return this.spinNode.getResult(queryID, requestorID);
    }

    @Override
    public ResultSet getResultNoDelete(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        if (DEBUG) {
            log.debug((Object)("Getting results (NOT deleting) for query " + queryID));
        }
        return this.spinNode.getResultNoDelete(queryID, requestorID);
    }

    @Override
    public boolean isComplete(String queryID) throws CacheException, QueryNotFoundException {
        boolean complete = this.spinNode.isComplete(queryID);
        if (DEBUG) {
            log.debug((Object)("Query " + queryID + " has " + (complete ? "" : "NOT") + " completed"));
        }
        return complete;
    }

    int countResponders(String queryID) throws CacheException, QueryNotFoundException {
        int numResponses = this.spinNode.countResponses(queryID);
        if (DEBUG) {
            log.debug((Object)("Query " + queryID + " has " + numResponses + " responses so far"));
        }
        return numResponses;
    }

    @Override
    public boolean hasUpdate(String queryID, int numResponders) throws CacheException, QueryNotFoundException {
        boolean hasUpdate = this.spinNode.hasUpdate(queryID, numResponders);
        if (DEBUG) {
            log.debug((Object)("Query " + queryID + (hasUpdate ? " has updates " : " has NO updates")));
        }
        return hasUpdate;
    }
}

