/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.spin.node.DefaultQueryNames;
import org.spin.node.NodeException;
import org.spin.node.dataaccess.types.AuditResult;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.Credentials;
import org.spin.query.message.agent.Querier;
import org.spin.query.message.agent.TimeoutException;
import org.spin.query.message.criteria.SPINLogCriteria;
import org.spin.query.message.identity.IdentityService;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.xml.sax.SAXException;

public final class Auditor {
    private final Querier querier;

    public Auditor(IdentityService identityService) throws ConfigException, NodeException {
        this(ConfigTool.loadAgentConfig(), identityService);
    }

    public Auditor(AgentConfig agentConfig, IdentityService identityService) throws ConfigException, NodeException {
        this.querier = new Querier(agentConfig, identityService);
    }

    public List<AuditResult> audit(SPINLogCriteria criteria) throws AgentException, JAXBException, IOException, SAXException {
        List<String> xmlResults;
        try {
            xmlResults = this.querier.query(DefaultQueryNames.Audit.queryType(), Credentials.Empty, criteria);
        }
        catch (TimeoutException e) {
            throw new AgentException((Throwable)((Object)e));
        }
        return Querier.unmarshallResults(xmlResults, AuditResult.class);
    }
}

