/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.headers.Result;
import org.spin.tools.Util;
import org.spin.tools.crypto.BadSignatureException;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.Cryptor;
import org.spin.tools.crypto.Envelope;
import org.spin.tools.crypto.signature.CertID;

public final class ResultDecryptor {
    private static final Logger log = Logger.getLogger(ResultDecryptor.class);
    private static final boolean INFO = log.isDebugEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final Cryptor cryptor;

    public ResultDecryptor(Cryptor cryptor) {
        Util.guardNotNull((Object)cryptor);
        this.cryptor = cryptor;
    }

    public final List<Result> decryptResults(Collection<Result> rawResults) throws AgentException {
        if (rawResults == null) {
            return null;
        }
        if (DEBUG) {
            log.debug((Object)("Processing " + rawResults.size() + " results"));
        }
        ArrayList processedResults = Util.makeArrayList((int)rawResults.size());
        for (Result result : rawResults) {
            if (result == null && INFO) {
                log.info((Object)"Null Result!");
            }
            this.logResult(result);
            try {
                Result decrypted = result == null ? null : this.decrypt(result);
                processedResults.add(decrypted);
            }
            catch (Exception e) {
                log.error((Object)("Error decrypting result from node '" + (result != null ? result.getOrigin() : "unknown") + "', continuing with other results"), (Throwable)e);
            }
        }
        return processedResults;
    }

    Result decrypt(Result result) {
        Envelope originalPayload = result.getPayload();
        return result.withPayload(Envelope.unencrypted((String)this.toPlaintext(result), (byte[])originalPayload.getSignature(), (CertID)originalPayload.getSignedBy()));
    }

    private void logResult(Result result) {
        if (DEBUG && result != null) {
            log.debug((Object)("nodeName: '" + result.getOrigin() + "'"));
            log.debug((Object)("encrypted: " + result.isEncrypted()));
            if (result.getPayload() != null) {
                String payload = result.getPayload().getData();
                log.debug((Object)("payload: " + payload.length() + " characters long"));
                int numChars = payload.length() > 200 ? 200 : payload.length();
                log.debug((Object)("first " + numChars + ": " + payload.substring(0, numChars)));
            } else {
                log.debug((Object)"Null payload");
            }
        }
    }

    final String toPlaintext(Result rawResult) throws CryptoException, BadSignatureException {
        if (rawResult == null) {
            return null;
        }
        Envelope envelope = rawResult.getPayload();
        boolean signed = envelope.isSigned();
        boolean encrypted = envelope.isEncrypted();
        if (encrypted && signed) {
            return this.cryptor.decryptAndVerify(envelope);
        }
        if (encrypted && !signed) {
            log.warn((Object)("Results from '" + rawResult.getDescription() + "' (" + rawResult.getOrigin() + ") are encrypted but not signed"));
            return this.cryptor.decrypt(rawResult.getPayload());
        }
        if (!encrypted && signed && !this.cryptor.verify(envelope)) {
            throw new BadSignatureException("Error verifying signature");
        }
        return envelope.getData();
    }
}

