/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import java.util.List;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.ResultDecryptor;
import org.spin.query.message.agent.SpinClientConfig;
import org.spin.query.message.agent.StringSerializer;
import org.spin.query.message.headers.EncryptionParams;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.QueryInput;
import org.spin.query.message.headers.Result;
import org.spin.query.message.headers.ResultSet;
import org.spin.tools.PKITool;
import org.spin.tools.Util;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.crypto.Cryptor;
import org.spin.tools.crypto.signature.Identity;

public final class SpinClient {
    private final SpinClientConfig config;

    public SpinClient(SpinClientConfig config) {
        Util.guardNotNull((Object)config);
        this.config = config;
    }

    public ResultSet query(String peerGroup, String queryType, Object criteria) {
        QueryInfo queryInfo = new QueryInfo().withAggregator(this.config.getEntryPoint()).withIdentity(this.certifyIdentity()).withPeerGroup(peerGroup).withQueryType(queryType);
        QueryInput queryInput = QueryInput.of((String)this.serialize(criteria), (EncryptionParams)this.config.getEncryptionParams());
        NodeConnector entryPoint = this.getNodeConnector(this.config.getEntryPoint());
        return this.decryptIfNecessary(entryPoint.blockingQuery(queryInfo, queryInput));
    }

    ResultSet decryptIfNecessary(ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        ResultDecryptor decryptor = new ResultDecryptor((Cryptor)PKITool.getInstance().cryptor());
        List<Result> decrypted = decryptor.decryptResults(resultSet.getResults());
        return resultSet.withResults(decrypted);
    }

    Identity certifyIdentity() {
        if (this.config.getCredentials() == null) {
            throw new AgentException("Can't certify identity: credentials are missing from SpinClientConfig");
        }
        return this.config.getCredentials().toIdentity(this.config.getIdentityService());
    }

    String serialize(Object criteria) {
        if (criteria instanceof String) {
            return StringSerializer.Null.toString(criteria);
        }
        return this.config.getSerializer().toString(criteria);
    }

    public SpinClientConfig getConfig() {
        return this.config;
    }

    public SpinClient withConfig(SpinClientConfig newConfig) {
        return new SpinClient(newConfig);
    }

    NodeConnector getNodeConnector(EndpointConfig entryPoint) {
        Util.guardNotNull((Object)entryPoint);
        Util.guardNotNull((Object)this.config.getNodeConnectorSource());
        NodeConnector nodeConnector = this.config.getNodeConnectorSource().getNodeConnector(entryPoint, this.config.getMaxWaitTime().longValue());
        return nodeConnector;
    }
}

