/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;
import org.spin.tools.config.KeyStoreType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="KeyStoreConfig", namespace="http://spin.org/xml/res/keystore")
@XmlRootElement(name="KeyStoreConfig", namespace="http://spin.org/xml/res/keystore")
public final class KeyStoreConfig {
    public static final KeyStoreConfig Default = new KeyStoreConfig();
    @XmlElement(required=true)
    private final File file;
    @XmlElement(required=true)
    private final String password;
    @XmlElement(required=false)
    private final String keyAlias;
    @XmlElement(required=false)
    private final List<String> caPublicKeyAlias = Util.makeArrayList();
    @XmlElement(required=false)
    private final Boolean attachCertificateToSignature;
    @XmlElement(required=false)
    private final Boolean setSystemProperties;
    @XmlElement(required=false)
    private final KeyStoreType keystoreType;
    public static final KeyStoreType defaultKeystoreType = KeyStoreType.JKS;
    public static final boolean defaultAttachCACert = false;
    public static final boolean defaultSetSystemProperties = false;

    private KeyStoreConfig() {
        this(new File(""), "password", null, null, false, false, KeyStoreType.JKS);
    }

    public KeyStoreConfig(File file, String password, String keyAlias, List<String> caPublicKeyAliases, boolean attachCertificateToSignature, boolean setSystemProperties, KeyStoreType keystoreType) {
        Util.guardNotNull(file, "Must reference a keystore file");
        Util.guardNotNull(password, "Must provide a password to access the keystore");
        this.file = file;
        this.password = password;
        this.keyAlias = keyAlias;
        if (caPublicKeyAliases != null) {
            this.caPublicKeyAlias.addAll(caPublicKeyAliases);
        }
        this.attachCertificateToSignature = attachCertificateToSignature;
        this.setSystemProperties = setSystemProperties;
        this.keystoreType = keystoreType == null ? defaultKeystoreType : keystoreType;
    }

    public File getFile() {
        return this.file;
    }

    public KeyStoreConfig withFile(File newFile) {
        return new KeyStoreConfig(newFile, this.password, this.keyAlias, this.caPublicKeyAlias, this.attachCertificateToSignature, this.setSystemProperties, this.keystoreType);
    }

    public String getPassword() {
        return this.password;
    }

    public KeyStoreConfig withPassword(String newPassword) {
        return new KeyStoreConfig(this.file, newPassword, this.keyAlias, this.caPublicKeyAlias, this.attachCertificateToSignature, this.setSystemProperties, this.keystoreType);
    }

    public char[] getPasswordAsCharArray() {
        return this.password.toCharArray();
    }

    public boolean getSetSystemProperties() {
        return this.setSystemProperties;
    }

    public KeyStoreConfig withSetSystemProperties(boolean newSetSystemProperties) {
        return new KeyStoreConfig(this.file, this.password, this.keyAlias, this.caPublicKeyAlias, this.attachCertificateToSignature, newSetSystemProperties, this.keystoreType);
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public KeyStoreConfig withKeyAlias(String newKeyAlias) {
        return new KeyStoreConfig(this.file, this.password, newKeyAlias, this.caPublicKeyAlias, this.attachCertificateToSignature, this.setSystemProperties, this.keystoreType);
    }

    public List<String> getCaPublicKeyAliases() {
        return new ArrayList<String>(this.caPublicKeyAlias);
    }

    public KeyStoreConfig withCaPublicKeyAliases(List<String> newCaPublicKeyAliases) {
        return new KeyStoreConfig(this.file, this.password, this.keyAlias, newCaPublicKeyAliases, this.attachCertificateToSignature, this.setSystemProperties, this.keystoreType);
    }

    public boolean getAttachCertificateToSignature() {
        return this.attachCertificateToSignature;
    }

    public KeyStoreConfig withAttachCACert(boolean newShouldAttachCACert) {
        return new KeyStoreConfig(this.file, this.password, this.keyAlias, this.caPublicKeyAlias, newShouldAttachCACert, this.setSystemProperties, this.keystoreType);
    }

    public KeyStoreType getKeystoreType() {
        return this.keystoreType;
    }

    public KeyStoreConfig withKeyStoreType(KeyStoreType newKeyStoreType) {
        return new KeyStoreConfig(this.file, this.password, this.keyAlias, this.caPublicKeyAlias, this.attachCertificateToSignature, this.setSystemProperties, newKeyStoreType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyStoreConfig that = (KeyStoreConfig)o;
        if (this.attachCertificateToSignature != that.attachCertificateToSignature) {
            return false;
        }
        if (this.setSystemProperties != that.setSystemProperties) {
            return false;
        }
        if (this.caPublicKeyAlias != null ? !((Object)this.caPublicKeyAlias).equals(that.caPublicKeyAlias) : that.caPublicKeyAlias != null) {
            return false;
        }
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        if (this.keyAlias != null ? !this.keyAlias.equals(that.keyAlias) : that.keyAlias != null) {
            return false;
        }
        if (this.keystoreType != that.keystoreType) {
            return false;
        }
        return !(this.password != null ? !this.password.equals(that.password) : that.password != null);
    }

    public int hashCode() {
        int result = this.file != null ? this.file.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.keyAlias != null ? this.keyAlias.hashCode() : 0);
        result = 31 * result + (this.caPublicKeyAlias != null ? ((Object)this.caPublicKeyAlias).hashCode() : 0);
        result = 31 * result + (this.attachCertificateToSignature != false ? 1 : 0);
        result = 31 * result + (this.setSystemProperties != false ? 1 : 0);
        result = 31 * result + (this.keystoreType != null ? this.keystoreType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "KeyStoreConfig{file=" + this.file + ", password='******', keyAlias='" + this.keyAlias + '\'' + ", caPublicKeyAlias=" + this.caPublicKeyAlias + ", attachCertificateToSignature=" + this.attachCertificateToSignature + ", setSystemProperties=" + this.setSystemProperties + ", keystoreType=" + (Object)((Object)this.keystoreType) + '}';
    }
}

