/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.config.PipelineStepConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PipelineConfig", namespace="http://spin.org/xml/res/etl", propOrder={"streamingPipeline", "streamSize", "transformerStrategy", "extractorStepConfig", "transformationStepConfigs", "loaderStepConfigs"})
@XmlRootElement(name="PipelineConfig", namespace="http://spin.org/xml/res/etl")
public class PipelineConfig {
    @XmlElement(required=false)
    protected Boolean streamingPipeline = false;
    @XmlElement(required=false)
    protected Integer streamSize = 1;
    @XmlElement(required=false)
    protected String transformerStrategy = "AllDataItemsAtOnce";
    @XmlElement(required=true)
    protected PipelineStepConfig extractorStepConfig;
    protected List<PipelineStepConfig> transformationStepConfigs;
    @XmlElement(required=true)
    protected List<PipelineStepConfig> loaderStepConfigs;

    public PipelineConfig() {
    }

    public PipelineConfig(PipelineStepConfig extractorConfig, List<PipelineStepConfig> transformerConfigs, List<PipelineStepConfig> loaderConfigs) {
        this.extractorStepConfig = extractorConfig;
        this.transformationStepConfigs = transformerConfigs;
        this.loaderStepConfigs = loaderConfigs;
    }

    public Boolean isStreamingPipeline() {
        return this.streamingPipeline;
    }

    public void setStreamingPipeline(Boolean value) {
        this.streamingPipeline = value;
    }

    public Integer getStreamSize() {
        return this.streamSize;
    }

    public void setStreamSize(Integer value) {
        this.streamSize = value;
    }

    public PipelineStepConfig getExtractorStepConfig() {
        return this.extractorStepConfig;
    }

    public void setExtractorStepConfig(PipelineStepConfig value) {
        this.extractorStepConfig = value;
    }

    public synchronized List<PipelineStepConfig> getTransformationStepConfigs() {
        if (this.transformationStepConfigs == null) {
            this.transformationStepConfigs = new ArrayList<PipelineStepConfig>();
        }
        return this.transformationStepConfigs;
    }

    public synchronized List<PipelineStepConfig> getLoaderStepConfigs() {
        if (this.loaderStepConfigs == null) {
            this.loaderStepConfigs = new ArrayList<PipelineStepConfig>();
        }
        return this.loaderStepConfigs;
    }

    public String getTransformerStrategy() {
        return this.transformerStrategy;
    }

    public void setTransformerStrategy(String transformationStrategy) {
        this.transformerStrategy = transformationStrategy;
    }
}

