/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.codec.binary.Base64;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EncryptedData")
@XmlRootElement
public final class Envelope {
    @XmlElement(required=true)
    protected final byte[] encryptedKey;
    @XmlElement(required=true)
    protected final String data;
    @XmlElement(required=false)
    protected final CertID encryptedFor;
    @XmlElement(required=false)
    protected final byte[] signature;
    @XmlElement(required=false)
    protected CertID signedBy;

    static String encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }

    static byte[] decode(String base64Data) {
        if (base64Data == null) {
            return null;
        }
        return Base64.decodeBase64((String)base64Data);
    }

    public static final Envelope unencrypted(String data) {
        return Envelope.unencrypted(data, null, null);
    }

    public static final Envelope unencrypted(String data, byte[] signature, CertID signedBy) {
        Util.guardNotNull(data);
        return new Envelope(null, data, null, signature, signedBy);
    }

    public static final Envelope encrypted(byte[] encryptedKey, byte[] data, CertID encryptedFor) {
        return Envelope.encrypted(encryptedKey, data, encryptedFor, null, null);
    }

    public static final Envelope encrypted(byte[] encryptedKey, byte[] data, CertID encryptedFor, byte[] signature, CertID signedBy) {
        Util.guardNotNull(encryptedKey);
        Util.guardNotNull(data);
        Util.guardNotNull(encryptedFor);
        return new Envelope(encryptedKey, Envelope.encode(data), encryptedFor, signature, signedBy);
    }

    public static final Envelope signed(Envelope unsigned, byte[] signature, CertID signedBy) {
        Util.guardNotNull(unsigned);
        Util.guardNotNull(signature);
        return new Envelope(unsigned.getEncryptedKey(), unsigned.getData(), unsigned.getEncryptedFor(), signature, signedBy);
    }

    private Envelope() {
        this(null, null, null, null, null);
    }

    private Envelope(byte[] encryptedKey, String data, CertID encryptedFor, byte[] signature, CertID signedBy) {
        this.encryptedKey = encryptedKey;
        this.data = data;
        this.encryptedFor = encryptedFor;
        this.signature = signature;
        this.signedBy = signedBy;
    }

    public final byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public final String getData() {
        return this.data;
    }

    public final byte[] getDataBytes() {
        if (this.isEncrypted()) {
            return Envelope.decode(this.data);
        }
        return this.data.getBytes();
    }

    public final boolean isEncrypted() {
        return this.encryptedFor != null && this.encryptedKey != null;
    }

    public final boolean isSigned() {
        return this.signature != null && this.signedBy != null;
    }

    public final CertID getEncryptedFor() {
        return this.encryptedFor;
    }

    public final byte[] getSignature() {
        return this.signature;
    }

    public CertID getSignedBy() {
        return this.signedBy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.encryptedFor == null ? 0 : this.encryptedFor.hashCode());
        result = 31 * result + Arrays.hashCode(this.encryptedKey);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Envelope other = (Envelope)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.encryptedFor == null ? other.encryptedFor != null : !this.encryptedFor.equals(other.encryptedFor)) {
            return false;
        }
        if (!Arrays.equals(this.encryptedKey, other.encryptedKey)) {
            return false;
        }
        return Arrays.equals(this.signature, other.signature);
    }
}

