/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.apache.log4j.Logger;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.PKITool;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.Signable;
import org.spin.tools.crypto.signature.Signature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLSignatureUtil {
    private final String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
    private final Logger log = Logger.getLogger(XMLSignatureUtil.class);
    private final boolean attachPublicKeyToSignatures;
    private final PKITool pkiTool;
    private static XMLSignatureUtil defaultInstance;
    private static final Object lock;

    private XMLSignatureUtil() throws ConfigException {
        this(PKITool.getInstance());
    }

    public XMLSignatureUtil(PKITool pkiTool) {
        Util.guardNotNull(pkiTool);
        this.pkiTool = pkiTool;
        this.attachPublicKeyToSignatures = pkiTool.getConfig().getAttachCertificateToSignature();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDefaultInstanceIfNecessary() throws ConfigException {
        Object object = lock;
        synchronized (object) {
            if (defaultInstance == null) {
                defaultInstance = new XMLSignatureUtil();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final XMLSignatureUtil getDefaultInstance() throws ConfigException {
        Object object = lock;
        synchronized (object) {
            XMLSignatureUtil.initDefaultInstanceIfNecessary();
            return defaultInstance;
        }
    }

    public Identity sign(Identity identity) throws XMLSignatureException {
        return this.sign(identity, this.attachPublicKeyToSignatures);
    }

    public Identity sign(Identity identity, boolean attachPublicKey) throws XMLSignatureException {
        return this.sign(identity.withNormalizedTimestamp(), Identity.class, attachPublicKey);
    }

    public <T> T sign(T toBeSigned, Class<T> classOfObjectToBeSigned) throws XMLSignatureException {
        return this.sign(toBeSigned, classOfObjectToBeSigned, this.attachPublicKeyToSignatures);
    }

    @Deprecated
    public <T> T sign(T identity, Class<T> classOfObjectToBeSigned, boolean attachMyPublicKey) throws XMLSignatureException {
        Element signedIdentityElement = this.signObject(identity, attachMyPublicKey);
        try {
            return JAXBUtils.unmarshal((Node)signedIdentityElement, classOfObjectToBeSigned);
        }
        catch (JAXBException e) {
            throw new XMLSignatureException("Error unmarshalling signed Identity", e);
        }
    }

    public Element signObject(Object rootXMLObject) throws XMLSignatureException {
        return this.signObject(rootXMLObject, this.attachPublicKeyToSignatures);
    }

    @Deprecated
    public Element signObject(Object toBeSigned, boolean attachMyPublicKey) throws XMLSignatureException {
        try {
            XMLSignatureFactory xmlSignatureFactory = this.getXMLSignatureFactory();
            Reference reference = xmlSignatureFactory.newReference("", xmlSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(xmlSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (XMLStructure)null)), null, null);
            SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (XMLStructure)null), xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(reference));
            Element element = JAXBUtils.marshalToElement(toBeSigned);
            DOMSignContext domSignContext = new DOMSignContext(this.pkiTool.getMyPrivateKey(), (Node)element);
            KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
            X509Certificate myX509PublicKeyCertificate = this.pkiTool.getX509Certificate(this.pkiTool.getMyCertID());
            X509IssuerSerial x509IssuerSerial = keyInfoFactory.newX509IssuerSerial(myX509PublicKeyCertificate.getIssuerX500Principal().getName(), myX509PublicKeyCertificate.getSerialNumber());
            List<Object> x509DataToInclude = attachMyPublicKey ? Arrays.asList(x509IssuerSerial, myX509PublicKeyCertificate) : Arrays.asList(x509IssuerSerial);
            X509Data x509Data = keyInfoFactory.newX509Data(x509DataToInclude);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Arrays.asList(x509Data));
            XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(domSignContext);
            return element;
        }
        catch (Exception e) {
            throw new XMLSignatureException("Failed to sign object", e);
        }
    }

    public final boolean verifySignature(Signable toBeVerified) throws XMLSignatureException {
        PublicKey signerKey;
        BigInteger keyID;
        try {
            keyID = toBeVerified.getSignature().getKeyInfo().getCertData().getCertID().getSerial();
        }
        catch (NullPointerException e) {
            this.log.warn((Object)"Can't determine signing key");
            return false;
        }
        try {
            X509Certificate attachedCertificate = this.getX509Certificate(toBeVerified.getSignature());
            if (attachedCertificate != null) {
                X509Certificate attachedCertSignerCert = this.pkiTool.getCaCertificate(attachedCertificate.getIssuerDN());
                PublicKey caPublicKey = attachedCertSignerCert.getPublicKey();
                attachedCertificate.verify(caPublicKey);
                if (this.verifySignature(toBeVerified, attachedCertificate.getPublicKey())) {
                    return true;
                }
            }
        }
        catch (CertificateException e) {
            this.log.info((Object)"Error getting Certificate Authority cert, proceding anyway.");
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)"No such algorithm");
        }
        catch (NoSuchProviderException e) {
            this.log.error((Object)"No such provider");
        }
        catch (InvalidKeyException e) {
            this.log.error((Object)"Invalid Key, check configuration");
        }
        catch (SignatureException e) {
            this.log.error((Object)"Signature Exception");
        }
        try {
            signerKey = this.pkiTool.getPublicKey(keyID);
        }
        catch (CryptoException e) {
            this.log.warn((Object)("Error getting signer key with serial '" + keyID + "', can't verify signature"), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.log.warn((Object)("Error getting signer key with serial '" + keyID + "', can't verify signature"), (Throwable)e);
            return false;
        }
        return this.verifySignature(toBeVerified, signerKey);
    }

    public final boolean verifySignature(Signable toBeVerified, PublicKey publicKey) throws XMLSignatureException {
        try {
            return this.verifySignature(JAXBUtils.marshalToElement(toBeVerified), publicKey);
        }
        catch (JAXBException e) {
            throw new XMLSignatureException("Couldn't unmarshal signed identity", e);
        }
    }

    public final boolean verifySignature(Element signedElement, PublicKey publicKey) throws XMLSignatureException {
        XMLSignature signature;
        NodeList signaturesNodeList = signedElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signaturesNodeList == null || signaturesNodeList.getLength() < 1) {
            throw new XMLSignatureException("No signature found!");
        }
        Node signatureNode = signaturesNodeList.item(0);
        if (signatureNode == null) {
            throw new XMLSignatureException("No signature found!");
        }
        DOMValidateContext domValidateContext = new DOMValidateContext(publicKey, signatureNode);
        try {
            signature = this.getXMLSignatureFactory().unmarshalXMLSignature(domValidateContext);
        }
        catch (MarshalException e) {
            throw new XMLSignatureException("Couldn't unmarshal XML signature", e);
        }
        return signature.validate(domValidateContext);
    }

    public final X509Certificate getX509Certificate(Signature signature) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        try {
            return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature.getKeyInfo().getCertData().getX509Certificate()));
        }
        catch (NullPointerException e) {
            this.log.error((Object)"Error getting attached X509 signature, possible misconfiguration");
            throw new CertificateException("Error getting attached certificate", e);
        }
    }

    private final XMLSignatureFactory getXMLSignatureFactory() throws XMLSignatureException {
        try {
            return XMLSignatureFactory.getInstance("DOM", ClassTools.createInstance(this.providerName, Provider.class));
        }
        catch (DynamicLoadingException e) {
            throw new XMLSignatureException("Couldn't create XMLSignatureFactory using provider class '" + this.providerName + "': ", e);
        }
    }

    static {
        lock = new Object();
    }

    public static enum SignerStrategy {
        AttachSigningKey,
        DoNotAttachSigningKey;

    }
}

