/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.connector;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.spin.node.NodeException;
import org.spin.node.NodeStatusInfo;
import org.spin.node.SPINWebserviceConstants;
import org.spin.node.SpinNode;
import org.spin.node.acknack.AckNack;
import org.spin.node.actions.QueryException;
import org.spin.node.connector.ConnectorUtils;
import org.spin.node.connector.NodeConnector;
import org.spin.node.connector.URLHandle;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.QueryInput;
import org.spin.query.message.headers.Result;
import org.spin.query.message.headers.ResultSet;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.Identity;

public final class LazyLoadingJAXWSNodeConnector
extends NodeConnector {
    private final URLHandle nodeWSDLURL;
    private SpinNode node;
    private final int maxWaitTime;

    @Override
    public String debug(String queryID) {
        this.lazyLoadWSDLIfNecessary(RuntimeException.class);
        return this.node.debug(queryID);
    }

    public LazyLoadingJAXWSNodeConnector(String nodeWSDLURL, int timeoutPeriod) throws NodeException {
        this(URLHandle.fromString(nodeWSDLURL), timeoutPeriod);
    }

    public LazyLoadingJAXWSNodeConnector(URL nodeWSDLURL, int maxWaitTime) throws NodeException {
        this(URLHandle.fromURL(nodeWSDLURL), maxWaitTime);
    }

    private LazyLoadingJAXWSNodeConnector(URLHandle nodeWSDLURL, int maxWaitTime) throws NodeException {
        super(String.valueOf(nodeWSDLURL));
        Util.guardNotNull((Object)nodeWSDLURL);
        Util.require((maxWaitTime > 0 ? 1 : 0) != 0);
        this.nodeWSDLURL = nodeWSDLURL;
        this.maxWaitTime = maxWaitTime;
    }

    SpinNode getNode() {
        return this.node;
    }

    URLHandle getNodeWSDLURL() {
        return this.nodeWSDLURL;
    }

    int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    private final synchronized <E extends Throwable> void lazyLoadWSDLIfNecessary(Class<E> exceptionClassToThrow) throws E {
        if (this.node == null) {
            URL nodeURL = null;
            try {
                nodeURL = this.nodeWSDLURL.value();
            }
            catch (MalformedURLException e) {
                ConnectorUtils.rethrow(exceptionClassToThrow, Util.concat((Object[])new Object[]{"Malformed URL: '", this.nodeWSDLURL, "', cannot connect to WSDL using JAXWS"}), e);
            }
            try {
                this.node = this.getSpinNode(nodeURL);
            }
            catch (NodeException e) {
                ConnectorUtils.rethrow(exceptionClassToThrow, Util.concat((Object[])new Object[]{"Error connecting to Node at URL: '", this.nodeWSDLURL, "'"}), e);
            }
        }
    }

    private final SpinNode getSpinNode(URL nodeURL) throws NodeException {
        if (nodeURL == null) {
            throw new NodeException("Null Node URL passed in");
        }
        if (LazyLoadingJAXWSNodeConnector.isSSL(nodeURL)) {
            ConnectorUtils.initializeKeystoreForSSL();
        }
        try {
            ConnectorUtils.suppressTooVerboseJAXWSLogging();
            return this.makeJAXWSProxy(nodeURL);
        }
        catch (Exception e) {
            throw new NodeException("Error connecting to JAXWS URL " + nodeURL, e);
        }
    }

    public SpinNode makeJAXWSProxy(URL nodeURL) {
        Service service = Service.create((URL)nodeURL, (QName)SPINWebserviceConstants.QserviceName);
        SpinNode port = (SpinNode)service.getPort(SPINWebserviceConstants.QportName, SpinNode.class);
        this.setTimeouts(port);
        return port;
    }

    private void setTimeouts(SpinNode proxy) {
        Map requestContext = ((BindingProvider)proxy).getRequestContext();
        requestContext.put("com.sun.xml.ws.connect.timeout", this.maxWaitTime);
        requestContext.put("com.sun.xml.ws.request.timeout", this.maxWaitTime);
    }

    @Override
    public synchronized NodeStatusInfo getNodeStatus() {
        this.lazyLoadWSDLIfNecessary(RuntimeException.class);
        return this.node.getNodeStatus();
    }

    @Override
    public synchronized Identity certify(String domain, String username, String password) throws IdentityServiceException {
        this.lazyLoadWSDLIfNecessary(IdentityServiceException.class);
        return this.node.certify(domain, username, password);
    }

    @Override
    public synchronized AckNack query(QueryInfo queryInfo, QueryInput criteria) throws QueryException {
        this.lazyLoadWSDLIfNecessary(QueryException.class);
        return this.node.query(queryInfo, criteria);
    }

    @Override
    public synchronized ResultSet blockingQuery(QueryInfo queryInfo, QueryInput criteria) throws QueryException {
        this.lazyLoadWSDLIfNecessary(QueryException.class);
        return this.node.blockingQuery(queryInfo, criteria);
    }

    @Override
    public synchronized void initQuery(QueryInfo queryInfo) {
        this.lazyLoadWSDLIfNecessary(RuntimeException.class);
        this.node.initQuery(queryInfo);
    }

    @Override
    public synchronized void aggregate(QueryInfo queryInfo, Result resultData) throws CacheException {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        this.node.aggregate(queryInfo, resultData);
    }

    @Override
    public synchronized int countResponses(String queryID) throws CacheException, QueryNotFoundException {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.node.countResponses(queryID);
    }

    @Override
    public synchronized ResultSet getResult(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.node.getResult(queryID, requestorID);
    }

    @Override
    public synchronized ResultSet getResultNoDelete(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.node.getResultNoDelete(queryID, requestorID);
    }

    @Override
    public synchronized boolean hasUpdate(String queryID, int numResponders) throws CacheException, QueryNotFoundException {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.node.hasUpdate(queryID, numResponders);
    }

    @Override
    public synchronized boolean isComplete(String queryID) throws CacheException, QueryNotFoundException {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.node.isComplete(queryID);
    }

    @Override
    public synchronized void expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) throws CacheException {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        this.node.expectResponse(queryInfo, statuses, numChildren);
    }
}

