package net.shrine.utilities.commands

import java.io.StringWriter
import au.com.bytecode.opencsv.CSVWriter

/**
 * @author clint
 * @date Sep 18, 2013
 */
trait ToCsvString[T <: Product] extends (Seq[T] >>> String) {
  override def apply(csvData: Seq[T]): String = {
    val stringWriter = new StringWriter

    val csvWriter = new CSVWriter(stringWriter)

    try {
      val rowsAsArraysOfFields = csvData.map(_.productIterator.map(String.valueOf).toArray)

      rowsAsArraysOfFields.foreach(csvWriter.writeNext)
    } finally {
      csvWriter.close()
    }

    stringWriter.toString
  }
}