/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.integration.reports;

import net.shrine.config.AdapterMappings;
import net.shrine.config.ShrineConfig;
import net.shrine.integration.ReportDTO;
import net.shrine.integration.util.LogUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.NodeConfig;

public class AdapterReport
extends ReportDTO {
    private static final Logger LOGGER = LogUtil.createLogger();

    public AdapterReport(ShrineConfig config) throws ConfigException {
        super("Adapter");
        NodeConfig nodeConfig = config.generateNodeConfig();
        ReportDTO.EntryDTO adpaterEnabledEntry = this.pack("Is adapter enabled?");
        ReportDTO.EntryDTO lockoutEntry = this.pack("Lockout");
        ReportDTO.EntryDTO resultWaitTimeEntry = this.pack("Result Wait Time");
        ReportDTO.EntryDTO mappingsGeneratedAtHostEntry = this.pack("Mappings Generated At Host");
        ReportDTO.EntryDTO mappingsGeneratedAtTimeEntry = this.pack("Mappings Generated At Time");
        ReportDTO.EntryDTO numberOfMappingKeysEntry = this.pack("Number of Mapping Keys");
        try {
            adpaterEnabledEntry.setValue(this.nvl((Object)nodeConfig.isQueryable()));
            lockoutEntry.setValue(Integer.toString(config.getAdapterLockoutAttemptsThreshold()));
            resultWaitTimeEntry.setValue(Integer.toString(config.getQueryTTL()));
            AdapterMappings adapterMappings = AdapterMappings.getDefaultInstance();
            mappingsGeneratedAtHostEntry.setValue(adapterMappings.getHostname());
            mappingsGeneratedAtTimeEntry.setValue(this.nvl((Object)adapterMappings.getTimestamp()));
            numberOfMappingKeysEntry.setValue(new Integer(adapterMappings.getEntries().size()).toString());
        }
        catch (Exception e) {
            LOGGER.log((Priority)Level.ERROR, (Object)"generate adapter", (Throwable)e);
            this.exception = e.getMessage();
        }
    }
}

