/**
 * @projectDescription	The main controller for the history viewport. (CRC's "previous queries" functionality)
 * @inherits 	i2b2.CRC.ctrlr
 * @namespace	i2b2.CRC.ctrlr.history
 * @author		Nick Benik, Griffin Weber MD PhD
 * @version 	1.3
 * ----------------------------------------------------------------------------------------
 * updated 9-15-08: RC4 launch [Nick Benik] 
 */
console.group('Load & Execute component file: CRC > ctrlr > History');
console.time('execute time');


i2b2.CRC.ctrlr.history = {
	clickedID: false,
	queryNewName: false,
	
// ================================================================================================== //
	Refresh: function() {
		console.info("CALLED i2b2.CRC.ctrlr.history.Refresh()");
		// THIS FUNCTION DOES THE FOLLOWING:
		//	1) fires a call to ajax.getCategories(), 
		//	2) interprets the XML / populates the ONT data model, 
		//	3) fires it's onDataUpdate event
        //update view from controller @todo: this is a bad practice...going with design already in place:
        $("refPrevQS").setStyle({
            display:'none'
        });
        $("refPrev2QS").setStyle({
            display:'inline'
        });


		// create a scoped callback message


        var scopeCB = new i2b2_scopedCallback();
		scopeCB.scope = i2b2.CRC.model.QueryMasters;
		scopeCB.callback = function(i2b2CellMsg) {
			// define the XML processing function
			console.group("CALLBACK Processing AJAX i2b2CellMsg");
			console.dir(i2b2CellMsg);
			
			i2b2.CRC.view.history.queryResponse = i2b2CellMsg.msgResponse;
			i2b2.CRC.view.history.queryRequest = i2b2CellMsg.msgRequest;
			i2b2.CRC.view.history.queryUrl = i2b2CellMsg.msgUrl;
			// the THIS scope is already set to i2b2.CRC.model.QueryMasters
			i2b2.sdx.Master.ClearAll('QM');
			if (!i2b2CellMsg.error) {		
				var qm = i2b2CellMsg.refXML.getElementsByTagName('query_master');
				for(var i=0; i<1*qm.length; i++) {
					var o = new Object;
					o.xmlOrig = qm[i];
					o.id = i2b2.h.getXNodeVal(qm[i],'query_master_id');
					o.realname = i2b2.h.getXNodeVal(qm[i],'name');
					o.userid = i2b2.h.getXNodeVal(qm[i],'user_id');
					o.group = i2b2.h.getXNodeVal(qm[i],'group_id');
					o.created = i2b2.h.getXNodeVal(qm[i],'create_date');
					o.master_type_cd = i2b2.h.getXNodeVal(qm[i],'master_type_cd');
				    o.flagged = i2b2.h.getXNodeVal(qm[i], 'flagged');
					
					var dStr = '';
					var d = o.created.match(/^[0-9\-]*/).toString();
					if (d) {
						d = d.replace(/-/g,'/');
						d = new Date(Date.parse(d));
						if (d) {
							dStr = ' [' + (d.getMonth()+1) + '-' + d.getDate() + '-' + d.getFullYear().toString() + ']';
						}
					}
					o.name = o.realname +  dStr + ' ['+o.userid+']';
					// encapsulate into an SDX package
					var sdxDataPack = i2b2.sdx.Master.EncapsulateData('QM',o);
					// save the node to the CRC data model
					i2b2.sdx.Master.Save(sdxDataPack, null);
				}
			} else {
				alert("An error has occurred in the Cell's AJAX library.\n Press F12 for more information");
			}
			// Broadcast an update event letting interested view controllers know that the Categories data model has been updated
			var DataUpdateSignal = {
				DataLocation: "i2b2.CRC.model.QueryMasters",
				DataRef: i2b2.CRC.model.QueryMasters
			}
			console.info("EVENT FIRE i2b2.CRC.ctrlr.gen.events.onDataUpdate; Msg:",DataUpdateSignal);
			console.groupEnd();
			i2b2.CRC.ctrlr.history.events.onDataUpdate.fire(DataUpdateSignal);

            //@todo: updating view from controller is bad...ugh!
            $("refPrev2QS").setStyle({
                display:'none'
            });
            $("refPrevQS").setStyle({
                display:'inline'
            });
		};
		
		// fire the AJAX call
		var options = {
			result_wait_time: 180,
			crc_max_records: i2b2.CRC.view['history'].params.maxQueriesDisp,
			crc_sort_by: i2b2.CRC.view['history'].params.sortBy,
			crc_user_type: 	(i2b2.PM.model.userRoles.indexOf("MANAGER") == -1? 	"CRC_QRY_getQueryMasterList_fromUserId" : "CRC_QRY_getQueryMasterList_fromGroupId"),	
			crc_sort_order: i2b2.CRC.view['history'].params.sortOrder
		};
		i2b2.CRC.ajax.getQueryMasterList_fromUserId("CRC:History", options, scopeCB);
	},

    /**
     * Asynchronous Unflag Query method.
     * Note: this method accesses the shrine rest calls directly, and therefore does
     * not currently subscribe to the i2b2 message format.
     * @param unflagQueryDto - {Object} - Data transfer object with queryId member.
     */
    Unflag: function( unflagQueryDto ){

        // create a scoped callback message
        var scopeCB = new i2b2_scopedCallback();
        scopeCB.scope = i2b2.CRC.model.QueryMasters;

        scopeCB.callback = function(i2b2CellMsg) {
            i2b2.CRC.ctrlr.history.Refresh();
        };

        // fire the AJAX call
        var options = {
            network_query_id: unflagQueryDto.queryId
        };

        i2b2.CRC.ajax.unFlagQueryMaster("CRC:History", options, scopeCB);
    },

    /**
     * Asynchronous Flag Query method.
     * Note: this method accesses the shrine rest calls directly, and therefore does
     * not currently subscribe to the i2b2 message format.
     * @param unflagQueryDto - {Object} - Data transfer object with queryId member.
     */
    Flag: function( flagQueryDto ){

        // create a scoped callback message
        var scopeCB = new i2b2_scopedCallback();
        scopeCB.scope = i2b2.CRC.model.QueryMasters;

        scopeCB.callback = function(i2b2CellMsg) {
            i2b2.CRC.ctrlr.history.Refresh();
        };

        // fire the AJAX call
        var options = {
            network_query_id: flagQueryDto.queryId
        };

        i2b2.CRC.ajax.flagQueryMaster("CRC:History", options, scopeCB);
    },
// ================================================================================================== //
    SyncRefresh: function() {
        console.info("CALLED i2b2.CRC.ctrlr.history.Refresh()");
        // THIS FUNCTION DOES THE FOLLOWING:
        //      1) fires a call to ajax.getCategories(),
        //      2) interprets the XML / populates the ONT data model,
        //      3) fires it's onDataUpdate event

        var scopeCB = new i2b2_scopedCallback();
        scopeCB.scope = i2b2.CRC.model.QueryMasters;
        scopeCB.callback = i2b2.CRC.ctrlr.history.refresh_callback2;

        // fire the AJAX call
        var options = {
            result_wait_time: 180,
            crc_max_records: i2b2.CRC.view['history'].params.maxQueriesDisp,
            crc_sort_by: i2b2.CRC.view['history'].params.sortBy,
            crc_sort_order: i2b2.CRC.view['history'].params.sortOrder
        };

        i2b2.CRC.ajax.getQueryMasterList_fromUserId("CRC:History", options, scopeCB);
        //var i2b2CellMsg = i2b2.CRC.ajax.getQueryMasterList_fromUserId("CRC:History", options);
        //i2b2.CRC.ctrlr.history.refresh_callback(i2b2CellMsg);
    },

// ================================================================================================== //
	queryDelete: function(qmID) {
		// function requires a Query Master ID
		var t = i2b2.sdx.Master.Load('QM',qmID);
		var QueryName = t.origData.name;
		if (confirm('Delete Query "' + QueryName + '"?')) {
			// create a scoped callback message 
			var scopeCB = new i2b2_scopedCallback();
			scopeCB.scope = i2b2.CRC.model.QueryMasters;
			scopeCB.callback = function(i2b2CellMsg) {
				// define the XML processing function
				console.group("CALLBACK Processing AJAX i2b2CellMsg");
				console.dir(i2b2CellMsg);
				i2b2.CRC.view.history.queryResponse = i2b2CellMsg.msgResponse;
				i2b2.CRC.view.history.queryRequest = i2b2CellMsg.msgRequest;
				i2b2.CRC.view.history.queryUrl = i2b2CellMsg.msgUrl;
				if (i2b2CellMsg.error) {		
					alert("An error has occurred in the Cell's AJAX library.\n Press F12 for more information");
				}
				// refresh the Query History data
				i2b2.CRC.ctrlr.history.Refresh();
			};
			
			// fire the AJAX call
			var options = {
				result_wait_time: 180,
				qm_key_value: qmID
			};
			i2b2.CRC.ajax.deleteQueryMaster("CRC:History", options, scopeCB);
		}
	},
	
	queryDeleteNoPrompt: function(qmID) {
		// function requires a Query Master ID
			// create a scoped callback message 
			var scopeCB = new i2b2_scopedCallback();
			scopeCB.scope = i2b2.CRC.model.QueryMasters;
			scopeCB.callback = function(i2b2CellMsg) {
				// define the XML processing function
				console.group("CALLBACK Processing AJAX i2b2CellMsg");
				console.dir(i2b2CellMsg);
				i2b2.CRC.view.history.queryResponse = i2b2CellMsg.msgResponse;
				i2b2.CRC.view.history.queryRequest = i2b2CellMsg.msgRequest;
				i2b2.CRC.view.history.queryUrl = i2b2CellMsg.msgUrl;
				//if (i2b2CellMsg.error) {		
				//	alert("An error has occurred in the Cell's AJAX library.\n Press F12 for more information");
				//}
				// refresh the Query History data
				i2b2.CRC.ctrlr.history.Refresh();
			};
			
			// fire the AJAX call
			var options = {
				result_wait_time: 180,
				qm_key_value: qmID
			};
			i2b2.CRC.ajax.deleteQueryMaster("CRC:History", options, scopeCB);
	},
	
// ================================================================================================== //
	queryRename: function(qmID, newQueryName, sdxPackage) {
		this.queryNewName = newQueryName || false;
		if (!this.queryNewName) {
			// callback for dialog submission
			var handleSubmit = function() {
				// submit value(s)
				var closure_qmID = qmID;
				if(this.submit()) {
					// run the query
					i2b2.CRC.ctrlr.history.queryRename(closure_qmID, $('inputQueryName').value);
				}
			}
			// display the query name input dialog
			this._queryPromptName(handleSubmit);
			// get the old name (and trim whitespace)
			$('inputQueryName').value = sdxPackage.origData.realname;
			return;
		}
		
		// create a scoped callback message 
		var scopeCB = new i2b2_scopedCallback();
		scopeCB.scope = this;
		scopeCB.callback = function(i2b2CellMsg) {
			// define the XML processing function
			console.group("CALLBACK Processing AJAX i2b2CellMsg");
			console.dir(i2b2CellMsg);
			i2b2.CRC.view.history.queryResponse = i2b2CellMsg.msgResponse;
			i2b2.CRC.view.history.queryRequest = i2b2CellMsg.msgRequest;
			i2b2.CRC.view.history.queryUrl = i2b2CellMsg.msgUrl;
			if (i2b2CellMsg.error) {		
				alert("An error has occurred in the Cell's AJAX library.\n Press F12 for more information");
			}
			// refresh the Query History data
			i2b2.CRC.ctrlr.history.Refresh();
			console.groupEnd();
		};
		// fire the AJAX call
		var options = {
			qm_key_value: qmID,
			qm_name: newQueryName
		};
		i2b2.CRC.ajax.renameQueryMaster("CRC:History", options, scopeCB);
	},
	
// ================================================================================================== //
	_queryPromptName: function(handleSubmit) {
		if (!i2b2.CRC.view.dialogQmName) {
			var handleCancel = function() {
				this.cancel();
			};
			var loopBackSubmit = function() {
				i2b2.CRC.view.dialogQmName.submitterFunction();
			};
			i2b2.CRC.view.dialogQmName = new YAHOO.widget.SimpleDialog("dialogQmName", {
					width: "400px",
					fixedcenter: true,
					constraintoviewport: true,
					modal: true,
					zindex: 700,
					buttons: [{
						text: "OK",
						handler: loopBackSubmit,
						isDefault: true
					}, {
						text: "Cancel",
						handler: handleCancel
					}]
				});
			$('dialogQmName').show();
			i2b2.CRC.view.dialogQmName.validate = function(){
				// now process the form data
				var msgError = '';
				var queryNameInput = $('inputQueryName');
				if (!queryNameInput || queryNameInput.value.blank()) {
					alert('Please enter a name for this query.');
					return false;
				}
				return true;
			};
			i2b2.CRC.view.dialogQmName.render(document.body);
		}
		// manage the event handler for submit
		delete i2b2.CRC.view.dialogQmName.submitterFunction;
		i2b2.CRC.view.dialogQmName.submitterFunction = handleSubmit;
		// display the dialoge
		i2b2.CRC.view.dialogQmName.center();
		i2b2.CRC.view.dialogQmName.show();
	}
}



// signal that is fired when the CRC cell's data model is updated
// ================================================================================================== //
i2b2.CRC.ctrlr.history.events = new Object;
i2b2.CRC.ctrlr.history.events.onDataUpdate = new YAHOO.util.CustomEvent("DataUpdate", i2b2.CRC);


console.timeEnd('execute time');
console.groupEnd();