# Fined [![NPM version][npm-image]][npm-url] [![Build Status][travis-image]][travis-url] [![Build Status][appveyor-image]][appveyor-url]

Find a file given a declaration of locations

## Usage

```js
var fined = require('fined');

fined({ path: 'path/to/file', extensions: ['.js', '.json'] });
// => { path: '/absolute/path/to/file.js', extension: '.js' }  (if file exists)
// => null  (if file does not exist)

var opts = {
  name: '.app',
  cwd: '.',
  extensions: {
    'rc': 'default-rc-loader', 
    '.yml': 'default-yml-loader',
  },
};

fined({ path: '.' }, opts);
// => { path: '/absolute/of/cwd/.app.yml', extension: { '.yml': 'default-yml-loader' } }

fined({ path: '~', extensions: { 'rc': 'some-special-rc-loader' } }, opts);
// => { path: '/User/home/.apprc', extension: { 'rc': 'some-special-rc-loader' } }
```

## API

### fined(pathObj, opts) => object | null

#### Arguments:

* **pathObj** [string | object] : a path setting for finding a file.
* **opts** [object] : a plain object supplements `pathObj`.

   `pathObj` and `opts` can have same properties:

   * **path** [string] : a path string.
   * **name** [string] : a basename.
   * **extensions**: [string | array | object] : extensions.
   * **cwd**: a base directory of `path` and for finding up.
   * **findUp**: [boolean] : a flag to find up.

#### Return:

This function returns a plain object which consists of following properties if a file exists otherwise null.

   * **path** : an absolute path
   * **extension** : a string or a plain object of extension.


## License

MIT


[npm-image]: http://img.shields.io/badge/npm-v0.0.0-blue.svg
[npm-url]: https://www.npmjs.org/package/fined
[travis-image]: https://travis-ci.org/js-cli/fined.svg?branch=master
[travis-url]: https://travis-ci.org/js-cli/fined
[appveyor-image]: https://ci.appveyor.com/api/projects/status/github/js-cli/fined?branch=master&svg=true
[appveyor-url]: https://ci.appveyor.com/project/js-cli/fined
