angular.module("app", ['ui.router', 'app-utils', 'login', 'navigation', 'topics', 'history', 'statistics', 'hms-authentication', 'description-per-role', 'hms-pagination', 'app-model'])
/**
 * App Config Phase - set up app routing.
 */
    .config(function($stateProvider, $httpProvider, $urlRouterProvider) {

        // --  CORS -- //
        $urlRouterProvider.otherwise('/topics');
        $httpProvider.defaults.useXDomain = true;
        delete $httpProvider.defaults.headers.common['X-Requested-With'];

        // -- No IE Cache -- //
        //http://stackoverflow.com/questions/16098430/angular-ie-caching-issue-for-http
        //initialize get if not there
        if (!$httpProvider.defaults.headers.get) {
            $httpProvider.defaults.headers.get = {};
        }
        //disable IE ajax request caching
        $httpProvider.defaults.headers.get['If-Modified-Since'] = 'Mon, 26 Jul 1997 05:00:00 GMT';
        // extra
        $httpProvider.defaults.headers.get['Cache-Control'] = 'no-cache';
        $httpProvider.defaults.headers.get['Pragma'] = 'no-cache';

        $stateProvider
            .state('topics', {
                url: '/topics',
                templateUrl: 'src/app/topics/topics.tpl.html',
                controller: 'TopicsCtrl'
            })
            // nested list with custom controller
            .state('history', {
                url: '/history',
                template: '<div query-history></div>'
            })
            // nested list with custom controller
            .state('statistics', {
                url: '/statistics',
                template: '<div query-statistics></div>'
            })
            .state('login', {
                url:            '/login',
                templateUrl:    'src/app/login/login.tpl.html',
                controller:     'LoginCtrl'
            });
    })
/**
 * App Run Phase - Set up listener to verify user has access.
 */
    .run(function ($rootScope, $location, AppUtilsService, UserRoles, $app) {

        $rootScope.$on( "$locationChangeStart", function (event, next, current) {
            // redirect to login page if not logged in
            if ($location.path() !== '/login' && (!$app.globals.currentUser || !$app.globals.currentUser.isLoggedIn)) {
                $location.path('/login');
            }
        });
    })
    .controller('AppCtrl', ['$rootScope', '$scope', '$location', '$app', 'AppMdl', function ($rootScope, $scope, $location, $app, AppMdl) {

        $scope.bannerUrl = '';
        $scope.helpUrl   = '';

        $scope.$app = $app;

        $scope.getConfigData = function () {
            AppMdl.getConfig()
                .then(function (data) {
                $scope.bannerUrl = data.banner;
                $scope.helpUrl   = data.help;
            });
        };

        $scope.getUsername = function () {
            return ($app.globals.currentUser) ?
                $app.globals.currentUser.username : '';
        };

        $scope.getRole = function () {
            if (!$app.globals.currentUser) {
                return '';
            }
            var idx = $app.globals.currentUser.roles.length - 1;
            return $app.globals.currentUser.roles[idx];
        };

        $scope.isUserLoggedIn = function () {
            return ($app.globals.currentUser !== undefined && $app.globals.currentUser.isLoggedIn === true);
        };

        $scope.logout = function () {
            $location.path('/login');
        };

        $scope.getConfigData();
    }])
    /**
     * Service for shared application methods and variables.
     */
    .constant("ViewConfig", {
        INDEX: 1,
        RANGE: 4,
        LIMIT: 5
    })
    .service("$app", function ($rootScope, AppUtilsService, UserRoles, ViewConfig) {
        //set app globals
        $rootScope.app = {
            globals: {
                AppTitleBase: "SHRINE DATA STEWARD",
                UserRoles:  UserRoles,
                ViewConfig: ViewConfig,
                States:     {
                    STATE1: "Pending",
                    STATE2: "Approved",
                    STATE3: "Rejected"
                }
            },
            utils:   AppUtilsService
        };

        // -- aggregate methods that access $rootscope. -- //
        $rootScope.app.utils.setAppUser = function (username, authdata, roles) {

            var userRoles = [roles[roles.length -1]];
            $rootScope.app.globals.currentUser = {
                username:   username,
                authdata:   authdata,
                isLoggedIn: true,
                roles:      userRoles
            };
        };

        $rootScope.app.utils.setAppTitle = function () {
            var titleArray  = $rootScope.app.globals.AppTitleBase.split(' ');
            titleArray[2]   = $rootScope.app.globals.currentUser.roles[0].toUpperCase();
            $rootScope.app.globals.AppTitle = titleArray.join(' ');
        };

        $rootScope.app.utils.clearAppTitle = function () {
            $rootScope.app.globals.AppTitle = $rootScope.app.globals.AppTitleBase;
        };

        $rootScope.app.utils.deleteAppUser = function () {
            delete $rootScope.app.globals.currentUser;
        };

        return {
            globals: $rootScope.app.globals,
            utils:   $rootScope.app.utils
        };
    });
