/**
 * Created by ben on 2/12/15.
 */
angular.module("hms-authentication", ['ngCookies', 'hms-authentication-model'])
    .constant("UserRoles", {
        ROLE1: "Researcher",
        ROLE2: "DataSteward",
        ROLE3: "Admin"
    })
    .factory('HMSAuthenticationService', ['$http', '$q', '$cookieStore', '$app', 'HMSAuthenticationModel', function ($http, $q, $cookieStore, $app, model) {

        var service     = {},
            researcher  = {username: 'ben',     password: 'kapow',  roles: ['researcher']},
            steward     = {username: 'dave',    password: 'kablam', roles: ['steward']};


        function SetUserRoles (roles) {
            return (username === "ben") ? researcher.roles : steward.roles;
        }

        service.Login = function () {
            return model.authenticate();
        };


        service.GetGlobalsCookie = function () {
            $cookieStore.get("globals");
        };

        service.SetAuthHeader = function (username, password) {
            var authdata = $app.utils.toBase64(username + ':' + password);
            $http.defaults.headers.common['Authorization'] =  'Basic ' + authdata;
        };

        service.SetCredentials = function (username, password, roles) {
            var authdata = $app.utils.toBase64(username + ':' + password);
            $app.utils.setAppUser(username, authdata, roles);
        };

        service.ClearCredentials = function () {
            if($app.globals.currentUser !== undefined) {
                $app.globals.currentUser.isLoggedIn = false;
            }
            $app.utils.deleteAppUser();
            $http.defaults.headers.common.Authorization = ' Basic ';
        };

        return service;
    }])
    .directive('restrict', function ($app) {
        return {
            restrict: 'A',
            priority: 100000,
            scope: {
                restrict: "@"
            },
            link: function ($scope, $element, $attrs) {
                var accessDenied,
                    user            = $app.globals.currentUser,
                    accessRoles     = $attrs.restrict.split(" ");

                //check if  matching roles.
                accessDenied = !$app.utils.hasAccess(user, accessRoles);

                if (accessDenied) {
                    $element.children().remove();
                    $element.remove();
                }
            }
        };
    });
