/**
 * Wrapper for interpolating settings with foundation paginator:
 * details for foundation paginator at:  http://pineconellc.github.io/angular-foundation/
 */
angular.module("hms-pagination", [])
    .directive("hmsPaginator", function () {
        return {
            scope: {
                range:          "@",
                totalItems:     "=",
                pageIndex:      "=",
                itemsPerPage:   "@",
                onPageSelected: "&"
            },
            restrict: 'A',
            templateUrl: "src/app/common/pagination/pagination.tpl.html",
            replace: true,
            link: function (scope) {
                scope.pageIndex  = 1;
                scope.onSelectPage = function (page) {
                    var data = {
                        range:          +scope.range,
                        totalItems:     +scope.totalItems,
                        pageIndex:      +page,
                        itemsPerPage:   +scope.itemsPerPage,
                        numPages:       +scope.numPages
                    };
                    scope.onPageSelected({data: data});
                };
            }
        };
    });
