angular
    .module("result-table", ['app-utils'])
    .directive("sortHeader", function () {
        return {
            restrict: 'E',
            transclude: true,
            templateUrl: 'src/app/common/result-table/sort-header.tpl.html',
            scope: {
                sort: "=",
                column: "@"
            },
            controller: function ($scope, $attrs) {

            }
        };
    })
    .service("ResultTable", function () {
        /**
         * Get config for Result Table directive
         * @param templatePath  - path to the html template.
         * @param dateFormatter - formatter for the date.
         * @param rolesArray    - array of appliction user roles.
         * @returns {{restrict: string, templateUrl: *, replace: boolean, scope: boolean, controller: *}}
         */
        this.getDirectiveConfig = function (templatePath, dateFormatter, rolesArray, callbackname) {
            return {
                restrict: "A",
                templateUrl: templatePath,
                replace: true,
                controller: function ($scope, $attrs) {
                    $scope.formatDate       = dateFormatter;
                    $scope.roles            = rolesArray;

                    $scope.sort = {
                        currentColumn: $attrs.sortedBy,
                        descending: false
                    };

                    /**
                     * Method for sorting columns
                     * @param column
                     */
                    $scope.sortBy = function (column) {
                        if ($scope.sort.currentColumn === column) {
                            $scope.sort.descending = !$scope.sort.descending;
                        } else {
                            $scope.sort.currentColumn  = column;
                            $scope.sort.descending = false;
                        }

                        $scope[callbackname]();
                    };
                }
            };
        };
    });

