angular.module("topic-detail-model", ["model-service"])
    .service("Role2TopicDetailMdl", ["$http", "ModelService", function ($http, mdlSvc) {
        var model = this,
            URLS = {
                APPROVE_TOPIC: "steward/approveTopic/topic/",
                REJECT_TOPIC: "steward/rejectTopic/topic/"
            };

        model.approveTopic = function (topicId) {
            var url = mdlSvc.url.base + URLS.APPROVE_TOPIC + topicId;
            return $http.post(url, {});
        };

        model.rejectTopic = function(topicId) {
            var url = mdlSvc.url.base + URLS.REJECT_TOPIC + topicId;
            return $http.post(url, {});
        };

        return model;
    }])
    .service("Role1TopicDetailMdl", ["$http", "ModelService", function ($http, mdlSvc) {

        /*
         curl -w " %{http_code}\n" -u ben:kapow -X POST "http://localhost:8080/steward/researcher/editTopicRequest/1" -H "Content-Type: application/json" -d '{"name":"KidneyStudy","description":"Kidney Study you should approve"}'
         */
        var model = this,
            URLS = {
                UPDATE_TOPIC: "researcher/editTopicRequest/"
            };

        model.updateTopic = function (id, name, description) {
            var url = mdlSvc.url.base + URLS.UPDATE_TOPIC + id;
            return $http.post(url, {
                name:        name,
                description: description
            });
        };

        return model;
    }])