angular.module("history-model", ['model-service'])
    .service("HistoryMdl", ['$http', 'ModelService', '$app', function ($http, mdlSvc, $app) {
        var queryRecords    = [],
            totalCount      = 0,
            skipped         = 0,
            state           = "",
            URLS        = {
                REQUEST_HISTORY: "/queryHistory"
            };

        function localResultExample() {

            var testResult = {
                "queryRecords":[
                    {
                        "id":1,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name":"KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents": "<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Approved",
                        "date":1425909884099
                    },
                    {
                        "id":2,
                        "name": "BadTopic",
                        "userId":"dave",
                        "queryContents": "bad topic from curl",
                        "stewardResponse": "Unknown For User",
                        "date":1425910034042
                    },
                    {
                        "id":3,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":4,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":5,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":6,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":7,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":8,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":9,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":10,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":11,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":12,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":13,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":14,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    },
                    {
                        "id":15,
                        "name":"FromCurl",
                        "userId":"dave",
                        "topic":
                        {
                            "id":1,
                            "name": "KidneyStudy",
                            "description":"Kidney Study",
                            "principalInvestigator":"dave",
                            "created":1425909001775,
                            "lastUpdate":1425909001775,
                            "state":"Approved"
                        },
                        "queryContents":"<queryDefinition><name>never married@16:48:56</name><expr><term>\\shrine\\shrine\\demographics\\marital status\\never married\\</term></expr></queryDefinition>",
                        "stewardResponse":"Rejected",
                        "date":1425910133351
                    }
                ]
            };

            return testResult;
        }

        function HistoryMdl(role) {
            this.role = role;
        }

        function onFail(result) {
            alert("Get History Failed: " + result);
        }

        function parseHistory(result) {

            queryRecords = result.data.queryRecords;
            skipped      = result.data.skipped;
            totalCount   = result.data.totalCount;
            return {
                queryRecords:   queryRecords,
                numberSkipped:  skipped,
                totalCount:     totalCount
            };
        }

        /*
         A researcher can also see his own query history
         > curl -w " %{http_code}\n" -u ben:kapow -X GET "http://localhost:8080/steward/researcher/queryHistory"
         */

        HistoryMdl.prototype.getHistory = function (skip, limit, sortBy, sortDirection, topicId) {

            var request  = URLS.REQUEST_HISTORY;
            if (topicId !== undefined) {
                request += '/topic/' + topicId;
            }

            var roleSegment = mdlSvc.getRoleSegment(this.role, $app.globals.UserRoles),
                url         = mdlSvc.getURL(mdlSvc.url.base + roleSegment + request, skip, limit, undefined, sortBy, sortDirection);

            return $http.get(url)
                .then(parseHistory, onFail);
        };


        this.getInstance = function (role) {
            return new HistoryMdl(role);
        };
    }]);
