///this utilizes https://github.com/fulup-bzh/DatePicker
angular.module("statistics", ['hms-datepicker', 'result-table', 'statistics-model'])
    .directive('queryStatistics', function ($app, StatisticsModel) {
        return {
            restrict: 'A',
            scope: {
                result: "="
            },
            templateUrl: 'src/app/statistics/statistics.tpl.html',
            controller: function ($scope, $element, $attrs) {

                var startDate = new Date(),
                    endDate   = new Date();

                startDate.setDate(endDate.getDate() - 7);

                $scope.getDateString = function (date) {
                    return $app.utils.utcToMMDDYYYY(date);
                };

                $scope.startDate = $scope.getDateString(startDate);
                $scope.endDate   = $scope.getDateString(endDate);
                $scope.isValid   = true;



                $scope.queriesPerUser = {};
                $scope.topicsPerState = {};


                $scope.validateRange = function () {

                    var startUtc, endUtc, secondsPerDay = 86400000;

                    if($scope.startDate === undefined || $scope.endDate === undefined) {
                        $scope.isValid = false;
                        return;
                    }

                    //can validate date range here.
                    startUtc = $app.utils.timestampToUtc($scope.startDate);
                    endUtc   = $app.utils.timestampToUtc($scope.endDate) + secondsPerDay;

                    if (endUtc - startUtc <= 0) {
                        $scope.isValid = false;
                    } else {
                        $scope.isValid = true;
                    }

                    return $scope.isValid;
                };

                $scope.addDateRange = function () {

                    var secondsPerDay = 86400000;

                    //range invalid, abandon ship.
                    if (!$scope.validateRange()) {
                        return;
                    }

                    $scope.getResults($app.utils.timestampToUtc($scope.startDate), $app.utils.timestampToUtc($scope.endDate) + secondsPerDay);
                };

                //@todo: this is workaround logic.
                $scope.parseStateTitle = function (state) {

                    var title = "";

                    if (state.Approved !== undefined) {
                        title =  "Approved";
                    }

                    else {
                        title =  (state.Rejected !== undefined) ? "Rejected" : "Pending";
                    }

                    return title;
                };

                //@todo: this is workaround logic.
                $scope.parseStateCount = function (state) {
                    var member = $scope.parseStateTitle(state);
                    return state[member];
                };


                $scope.getResults =  function (startUtc, endUtc) {
                    StatisticsModel.getQueriesPerUser(startUtc, endUtc)
                        .then(function (result) {
                            $scope.queriesPerUser = result;
                        });

                    StatisticsModel.getTopicsPerState(startUtc, endUtc)
                        .then(function (result) {
                            $scope.topicsPerState = result;
                        });
                };

                $scope.addDateRange();
            }
        };
    })
    .directive("queryCounts", function ($app, ResultTable) {
        return ResultTable.getDirectiveConfig("src/app/statistics/query-counts-table.tpl.html",
            $app.utils.utcToTimeStamp,
            $app.globals.UserRoles,
            'refreshMethod');
    })
    .directive("topicStatus", function ($app, ResultTable) {
        return ResultTable.getDirectiveConfig("src/app/statistics/query-topic-status-table.tpl.html",
            $app.utils.utcToTimeStamp,
            $app.globals.UserRoles,
            'refreshMethod');
    });


