/**
* Query Topics Controller
* @author   Ben Carmen
* @date     04/04/2015
* Edit Log:
*    @todo: bdc -- 04-05-15 -- consider moving common paging methods to the base config for result-table.
*/

angular.module("topics", ['result-table', 'topics-model', 'hms-modal', 'topic-detail'])
    .controller('TopicsCtrl', ['$scope', 'ResultTable', 'TopicsModelFactory', '$app', function ($scope, ResultTable, ModelFactory, $app) {

        //private vars
        var roles = $app.globals.UserRoles,
            user  = $app.globals.currentUser,
            utils = $app.utils,
            scope = $scope,
            role, model, initState;

        //determine role of user.
        role        = (utils.hasAccess(user, [roles.ROLE2])) ? roles.ROLE2 : roles.ROLE1;
        initState   = (role === roles.ROLE2) ? $app.globals.States.STATE1 : "ALL";
        model       = ModelFactory.getInstance(role);

        //
        $scope.states = $app.globals.States;
        $scope.topics = [];
        $scope.filterBy = 'topicName';
        $scope.sort = {
            currentColumn: 'changeDate',
            descending: false
        };
        $scope.selectedTab = initState;

        /**
         * Parent scope data referenced by children.
         * @type {{topics: Array, name: string, description: string, sort: {column: string, descending: boolean}}}
         */
        $scope.data = {
            name:        'name',
            description: 'description'
        };

        //set pagination values.
        $scope.range        = $app.globals.ViewConfig.RANGE;//range of paging numbers at bottom
        $scope.length       = 0;                            //total number of results
        $scope.pageIndex    = $app.globals.ViewConfig.INDEX;//current page
        $scope.limit        = $app.globals.ViewConfig.LIMIT;//number of results to show in table at per page.
        $scope.skip         = 0;                            //number of results to skip.

        /*
         * Handler for when pagination page is changed.
         * @param: data containing information about the current state of the pagination control.
         */
        $scope.onPageSelected = function (data) {
            var mult;
            $scope.pageIndex = data.pageIndex;
            mult             = ($scope.pageIndex > 0) ? $scope.pageIndex - 1 : 0;
            $scope.skip      = $scope.limit * mult;
            $scope.refreshTopics($scope.skip, $scope.limit);
        };

        $scope.setStateAndRefresh = function (state) {
            $scope.state =  state;

            if ($scope.sort) {
                $scope.sort.currentColumn = 'changeDate';
                $scope.sort.descending    = false;
            }

            $scope.refreshTopics();
        };

        $scope.refreshTopics = function () {

            var state, sortBy = 'changeDate', sortDirection = 'ascending';

            if ($scope.state !== "ALL") {
                state = $scope.state;
            }

            if ($scope.sort && $scope.sort.currentColumn !== "") {
                sortBy          = $scope.sort.currentColumn;
                sortDirection   = ($scope.sort.descending) ? "descending" : "ascending";
            }
            model.getTopics($scope.skip, $scope.limit, state, sortBy, sortDirection)
                .then(function (result) {
                    scope.topics    = result.topics;
                    $scope.length   = result.totalCount;
                });
        };

        $scope.getTitle = function (state) {
            var title = " Query Topics";

            return (role === roles.ROLE2) ?
                ($scope.state + title) : title;
        };

        /**
         * Modal Configuration for creating a new topic.
         * @type {{templateUrl: string, controller: Function}}
         */
        $scope.newTopicConfig = {
            templateUrl: 'src/app/topics/new/new-topic.tpl.html',
            controller: function ($scope, $modalInstance) {

                $scope.newTopic = {name: "", description: ""};
                $scope.ok = function () {
                    var name        = $scope.newTopic.name,
                        description = $scope.newTopic.description;
                    model
                        .requestNewTopic({"name": name, "description": description})
                        .then(function () {
                            scope.refreshTopics();
                            $modalInstance.close();
                        });
                };

                $scope.cancel = function () {
                    $modalInstance.dismiss('cancel');
                };
            }
        };

        /**
         * Modal Configuration for viewing a topic.
         * @type {{templateUrl: string, controller: string}}
         */
        $scope.viewTopicConfig = {
            templateUrl: 'src/app/common/topic-detail/topic-detail.tpl.html',
            controller: 'TopicDetailCtrl'
        };

        $scope.setStateAndRefresh(initState);
    }])
    .directive("topicTable", function ($app, ResultTable) {
        return ResultTable.getDirectiveConfig("src/app/topics/topic-table/topic-table.tpl.html",
            $app.utils.utcToMMDDYYYY,
            $app.globals.UserRoles,
            'refreshTopics');
    });

