/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.OpenBitSetDISI;
import org.apache.lucene.util.Version;

public class PKIndexSplitter {
    private final Filter docsInFirstIndex;
    private final Directory input;
    private final Directory dir1;
    private final Directory dir2;

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Filter docsInFirstIndex) {
        this.input = input;
        this.dir1 = dir1;
        this.dir2 = dir2;
        this.docsInFirstIndex = docsInFirstIndex;
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Term midTerm) {
        this(input, dir1, dir2, (Filter)new TermRangeFilter(midTerm.field(), null, midTerm.text(), true, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split() throws IOException {
        boolean bl;
        boolean success = false;
        IndexReader reader = IndexReader.open((Directory)this.input);
        try {
            this.createIndex(this.dir1, reader, this.docsInFirstIndex, false);
            this.createIndex(this.dir2, reader, this.docsInFirstIndex, true);
            success = true;
            bl = !success;
        }
        catch (Throwable throwable) {
            IOUtils.closeSafely((!success ? 1 : 0) != 0, (Closeable[])new Closeable[]{reader});
            throw throwable;
        }
        IOUtils.closeSafely((boolean)bl, (Closeable[])new Closeable[]{reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(Directory target, IndexReader reader, Filter preserveFilter, boolean negateFilter) throws IOException {
        boolean bl;
        boolean success = false;
        IndexWriter w = new IndexWriter(target, new IndexWriterConfig(Version.LUCENE_CURRENT, null).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        try {
            w.addIndexes(new IndexReader[]{new DocumentFilteredIndexReader(reader, preserveFilter, negateFilter)});
            success = true;
            bl = !success;
        }
        catch (Throwable throwable) {
            IOUtils.closeSafely((!success ? 1 : 0) != 0, (Closeable[])new Closeable[]{w});
            throw throwable;
        }
        IOUtils.closeSafely((boolean)bl, (Closeable[])new Closeable[]{w});
    }

    public static class DocumentFilteredIndexReader
    extends FilterIndexReader {
        final OpenBitSetDISI readerDels;
        final int numDocs;

        public DocumentFilteredIndexReader(IndexReader reader, Filter preserveFilter, boolean negateFilter) throws IOException {
            super(reader);
            DocIdSetIterator it;
            OpenBitSetDISI bits = new OpenBitSetDISI(this.in.maxDoc());
            DocIdSet docs = preserveFilter.getDocIdSet(this.in);
            if (docs != null && (it = docs.iterator()) != null) {
                bits.inPlaceOr(it);
            }
            if (!negateFilter) {
                bits.flip(0L, (long)this.in.maxDoc());
            }
            if (this.in.hasDeletions()) {
                for (int i = 0; i < this.in.maxDoc(); ++i) {
                    if (!this.in.isDeleted(i)) continue;
                    bits.set((long)i);
                }
            }
            this.readerDels = bits;
            this.numDocs = this.in.maxDoc() - (int)bits.cardinality();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public boolean hasDeletions() {
            return this.in.maxDoc() != this.numDocs;
        }

        public boolean isDeleted(int n) {
            return this.readerDels.get(n);
        }

        public IndexReader[] getSequentialSubReaders() {
            return null;
        }

        public TermPositions termPositions() throws IOException {
            return new FilterIndexReader.FilterTermPositions(this.in.termPositions()){

                public boolean next() throws IOException {
                    boolean res;
                    while ((res = super.next()) && DocumentFilteredIndexReader.this.readerDels.get(this.doc())) {
                    }
                    return res;
                }
            };
        }
    }
}

