/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named
public class JarIdentificationAnalysis {
    private final List<JarIdentificationExposer> exposers;

    @Inject
    public JarIdentificationAnalysis(List<JarIdentificationExposer> exposers) {
        this.exposers = Objects.requireNonNull(exposers);
    }

    public JarIdentification analyze(JarAnalyzer jarAnalyzer) {
        JarIdentification taxon = jarAnalyzer.getJarData().getJarIdentification();
        if (taxon != null) {
            return taxon;
        }
        taxon = new JarIdentification();
        for (JarIdentificationExposer exposer : this.exposers) {
            exposer.expose(taxon, jarAnalyzer);
        }
        this.normalize(taxon);
        jarAnalyzer.getJarData().setJarIdentification(taxon);
        return taxon;
    }

    private void normalize(JarIdentification taxon) {
        if (StringUtils.isEmpty((String)taxon.getGroupId())) {
            taxon.setGroupId(this.pickSmallest(taxon.getPotentialGroupIds()));
        }
        if (StringUtils.isEmpty((String)taxon.getArtifactId())) {
            taxon.setArtifactId(this.pickLargest(taxon.getPotentialArtifactIds()));
        }
        if (StringUtils.isEmpty((String)taxon.getVersion())) {
            taxon.setVersion(this.pickSmallest(taxon.getPotentialVersions()));
        }
        if (StringUtils.isEmpty((String)taxon.getName())) {
            taxon.setName(this.pickLargest(taxon.getPotentialNames()));
        }
        if (StringUtils.isEmpty((String)taxon.getVendor())) {
            taxon.setVendor(this.pickLargest(taxon.getPotentialVendors()));
        }
    }

    private String pickSmallest(List<String> list) {
        String smallest = null;
        int size = Integer.MAX_VALUE;
        for (String val : list) {
            if (val == null || val.isEmpty() || val.length() >= size) continue;
            smallest = val;
            size = val.length();
        }
        return smallest;
    }

    private String pickLargest(List<String> list) {
        String largest = null;
        int size = Integer.MIN_VALUE;
        for (String val : list) {
            if (val == null || val.isEmpty() || val.length() <= size) continue;
            largest = val;
            size = val.length();
        }
        return largest;
    }
}

