/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.classpath.ClassPathResolver;
import org.awaitility.core.CheckedExceptionRethrower;
import org.awaitility.core.ConditionEvaluationHandler;
import org.awaitility.core.ConditionEvaluationResult;
import org.awaitility.core.ConditionEvaluator;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.core.DeadlockException;
import org.awaitility.core.TemporalDuration;
import org.awaitility.core.Uninterruptibles;

abstract class ConditionAwaiter
implements Thread.UncaughtExceptionHandler {
    private final ExecutorService executor;
    private final ConditionEvaluator conditionEvaluator;
    private final AtomicReference<Throwable> uncaughtThrowable;
    private final ConditionSettings conditionSettings;
    private final Thread.UncaughtExceptionHandler originalDefaultUncaughtExceptionHandler;

    ConditionAwaiter(ConditionEvaluator conditionEvaluator, ConditionSettings conditionSettings) {
        if (conditionEvaluator == null) {
            throw new IllegalArgumentException("You must specify a condition (was null).");
        }
        if (conditionSettings == null) {
            throw new IllegalArgumentException("You must specify the condition settings (was null).");
        }
        this.originalDefaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (conditionSettings.shouldCatchUncaughtExceptions()) {
            Thread.setDefaultUncaughtExceptionHandler(this);
        }
        this.conditionSettings = conditionSettings;
        this.conditionEvaluator = conditionEvaluator;
        this.executor = conditionSettings.getExecutorLifecycle().supplyExecutorService();
        this.uncaughtThrowable = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void await(ConditionEvaluationHandler<T> conditionEvaluationHandler) {
        Duration pollDelay = this.conditionSettings.getPollDelay();
        Duration maxWaitTime = this.conditionSettings.getMaxWaitTime();
        Duration minWaitTime = this.conditionSettings.getMinWaitTime();
        Duration holdPredicateWaitTime = this.conditionSettings.getHoldPredicateTime();
        long pollingStartedNanos = System.nanoTime() - pollDelay.toNanos();
        int pollCount = 0;
        boolean succeededBeforeTimeout = false;
        ConditionEvaluationResult lastResult = null;
        Duration evaluationDuration = Duration.of(0L, ChronoUnit.MILLIS);
        Future<ConditionEvaluationResult> currentConditionEvaluation = null;
        long firstSucceedSinceStarted = 0L;
        try {
            if (this.executor.isShutdown() || this.executor.isTerminated()) {
                throw new IllegalStateException("The executor service that Awaitility is instructed to use has been shutdown so condition evaluation cannot be performed. Is there something wrong the thread or executor configuration?");
            }
            conditionEvaluationHandler.start();
            if (!pollDelay.isZero()) {
                Uninterruptibles.sleepUninterruptibly(pollDelay.toNanos(), TimeUnit.NANOSECONDS);
            }
            Duration pollInterval = pollDelay;
            while (maxWaitTime.compareTo(evaluationDuration) > 0) {
                ++pollCount;
                Duration maxWaitTimeForThisCondition = maxWaitTime.minus(evaluationDuration);
                currentConditionEvaluation = this.executor.submit(new ConditionPoller(pollInterval));
                ConditionEvaluationResult conditionEvaluationResult = lastResult = ChronoUnit.FOREVER.getDuration().equals(maxWaitTime) ? Uninterruptibles.getUninterruptibly(currentConditionEvaluation) : Uninterruptibles.getUninterruptibly(currentConditionEvaluation, maxWaitTimeForThisCondition);
                if (lastResult.isSuccessful() && firstSucceedSinceStarted == 0L) {
                    firstSucceedSinceStarted = System.nanoTime();
                } else if (lastResult.isError()) {
                    firstSucceedSinceStarted = 0L;
                }
                if (lastResult.isSuccessful() && System.nanoTime() - firstSucceedSinceStarted >= holdPredicateWaitTime.toNanos() || lastResult.hasThrowable()) break;
                if (lastResult.hasTrace()) {
                    conditionEvaluationHandler.handleIgnoredException(lastResult.getTrace());
                }
                pollInterval = this.conditionSettings.getPollInterval().next(pollCount, pollInterval);
                Uninterruptibles.sleepUninterruptibly(pollInterval.toNanos(), TimeUnit.NANOSECONDS);
                evaluationDuration = ConditionAwaiter.calculateConditionEvaluationDuration(pollDelay, pollingStartedNanos);
            }
            succeededBeforeTimeout = maxWaitTime.compareTo(evaluationDuration = ConditionAwaiter.calculateConditionEvaluationDuration(pollDelay, pollingStartedNanos)) > 0;
        }
        catch (TimeoutException e) {
            lastResult = new ConditionEvaluationResult(false, null, e);
        }
        catch (ExecutionException e) {
            lastResult = new ConditionEvaluationResult(false, e.getCause(), null);
        }
        catch (Throwable e) {
            lastResult = new ConditionEvaluationResult(false, e, null);
        }
        finally {
            if (currentConditionEvaluation != null) {
                currentConditionEvaluation.cancel(true);
            }
        }
        try {
            String message;
            if (this.uncaughtThrowable.get() != null) {
                throw this.uncaughtThrowable.get();
            }
            if (lastResult != null && lastResult.hasThrowable()) {
                throw lastResult.getThrowable();
            }
            if (!succeededBeforeTimeout) {
                Throwable cause;
                String timeoutMessage = this.getTimeoutMessage();
                String durationAsString = TemporalDuration.formatAsString(maxWaitTime);
                message = this.conditionSettings.hasAlias() ? String.format("Condition with alias '%s' didn't complete within %s because %s.", this.conditionSettings.getAlias(), durationAsString, ConditionAwaiter.decapitalize(timeoutMessage)) : String.format("%s within %s.", timeoutMessage, durationAsString);
                Throwable throwable = cause = lastResult != null && lastResult.hasTrace() ? lastResult.getTrace() : null;
                if (ClassPathResolver.existInCP("java.lang.management.ThreadMXBean") && ClassPathResolver.existInCP("java.lang.management.ManagementFactory")) {
                    ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                    try {
                        long[] threadIds = bean.findDeadlockedThreads();
                        if (threadIds != null) {
                            cause = new DeadlockException(threadIds);
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                conditionEvaluationHandler.handleTimeout(message, false);
                throw new ConditionTimeoutException(message, cause);
            }
            if (evaluationDuration.compareTo(minWaitTime) < 0) {
                message = String.format("Condition was evaluated in %s which is earlier than expected minimum timeout %s", TemporalDuration.formatAsString(evaluationDuration), TemporalDuration.formatAsString(minWaitTime));
                conditionEvaluationHandler.handleTimeout(message, true);
                throw new ConditionTimeoutException(message);
            }
        }
        catch (Throwable e) {
            CheckedExceptionRethrower.safeRethrow(e);
        }
        finally {
            Thread.setDefaultUncaughtExceptionHandler(this.originalDefaultUncaughtExceptionHandler);
            this.uncaughtThrowable.set(null);
            this.conditionSettings.getExecutorLifecycle().executeNormalCleanupBehavior(this.executor);
        }
    }

    private static String decapitalize(String str) {
        if (str == null) {
            return "";
        }
        String firstLetter = str.substring(0, 1).toLowerCase();
        String restLetters = str.substring(1);
        return firstLetter + restLetters;
    }

    protected abstract String getTimeoutMessage();

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (!this.conditionSettings.shouldExceptionBeIgnored(throwable)) {
            this.uncaughtThrowable.set(throwable);
            this.conditionSettings.getExecutorLifecycle().executeUnexpectedCleanupBehavior(this.executor);
        }
    }

    static Duration calculateConditionEvaluationDuration(Duration pollDelay, long pollingStarted) {
        long calculatedDuration = System.nanoTime() - pollingStarted - pollDelay.toNanos();
        long potentiallyCompensatedDuration = Math.max(calculatedDuration, 1L);
        return Duration.of(potentiallyCompensatedDuration, ChronoUnit.NANOS);
    }

    private class ConditionPoller
    implements Callable<ConditionEvaluationResult> {
        private final Duration delayed;

        ConditionPoller(Duration delayed) {
            this.delayed = delayed;
        }

        @Override
        public ConditionEvaluationResult call() {
            try {
                return ConditionAwaiter.this.conditionEvaluator.eval(this.delayed);
            }
            catch (Throwable e) {
                if (ConditionAwaiter.this.conditionSettings.shouldExceptionBeIgnored(e)) {
                    return new ConditionEvaluationResult(false, null, e);
                }
                return new ConditionEvaluationResult(false, e, null);
            }
        }
    }
}

