/*
 * Decompiled with CFR 0.152.
 */
package org.harvard.hms.cbmi.jira;

import com.atlassian.jira.rpc.soap.client.JiraSoapService;
import com.atlassian.jira.rpc.soap.client.RemoteComment;
import com.atlassian.jira.rpc.soap.client.RemoteComponent;
import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import org.harvard.hms.cbmi.jira.SOAPSession;

public class SOAPClient {
    static final String LOGIN_NAME = "soaptester";
    static final String LOGIN_PASSWORD = "soaptester";
    static final String ISSUE_TYPE_ID = "1";
    static final String NEW_COMMENT_BODY = "This is a new comment";
    static final String FILTER_ID_FIXED_FOR_RELEASED_VERSION = "12355";
    static final String SOAP_AS_A_SEARCH_TERM = "SOAPClient";
    SOAPSession soapSession = null;
    JiraSoapService jiraSoapService = null;
    String authToken = null;

    private void setAuthToken(String aToken) {
        this.authToken = aToken;
    }

    private void setJiraSoapService(JiraSoapService aJiraService) {
        this.jiraSoapService = aJiraService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPClient(String baseUrl, String loginName, String loginPwd) {
        try {
            this.soapSession = new SOAPSession(new URL(baseUrl));
            this.soapSession.connect(loginName, loginPwd);
            this.setJiraSoapService(this.soapSession.getJiraSoapService());
            this.setAuthToken(this.soapSession.getAuthenticationToken());
        }
        catch (MalformedURLException murlx) {
            System.out.println("\tMalformedURLException on creating SOAPClient: " + murlx.getMessage());
            murlx.printStackTrace();
        }
        catch (RemoteException rx) {
            System.out.println("\tRemoteException on creating SOAPClient: " + rx.getMessage());
            rx.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttachment(JiraSoapService jiraSoapService, String token, RemoteIssue issue) throws IOException {
        Timing timing = Timing.startTiming("AddAttachment");
        try {
            File tmpFile = File.createTempFile("attachment", ".txt");
            FileWriter fw = new FileWriter(tmpFile);
            fw.write("A sample file attached via SOAP to JIRA issue " + issue.getKey());
            fw.close();
            boolean added = jiraSoapService.addAttachmentsToIssue(token, issue.getKey(), new String[]{tmpFile.getName()}, new byte[][]{this.getBytesFromFile(tmpFile)});
            System.out.println("\t" + (added ? "Added" : "Failed to add") + " attachment " + tmpFile.getName() + " to issue " + issue.getKey());
            tmpFile.delete();
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addComment(JiraSoapService jiraSoapService, String token, String issueKey) throws RemoteException {
        Timing timing = Timing.startTiming("AddComment");
        try {
            RemoteComment comment = new RemoteComment();
            comment.setBody(NEW_COMMENT_BODY);
            jiraSoapService.addComment(token, issueKey, comment);
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteIssue createIssue(String jiraProjectKey, String jiraComponentID, String summary, String description) throws RemoteException {
        RemoteIssue returnedIssue = null;
        RemoteIssue issue = new RemoteIssue();
        issue.setProject(jiraProjectKey);
        issue.setType(ISSUE_TYPE_ID);
        issue.setSummary(summary);
        issue.setAssignee("");
        RemoteComponent component = new RemoteComponent();
        component.setId(jiraComponentID);
        issue.setComponents(new RemoteComponent[]{component});
        issue.setDescription(description);
        returnedIssue = this.jiraSoapService.createIssue(this.authToken, issue);
        return returnedIssue;
    }

    private void printIssueDetails(RemoteIssue issue) {
        System.out.println("Issue Details : ");
        Method[] declaredMethods = issue.getClass().getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            if (!declaredMethod.getName().startsWith("get") || declaredMethod.getParameterTypes().length != 0) continue;
            System.out.print("\t Issue." + declaredMethod.getName() + "() -> ");
            try {
                Object obj = declaredMethod.invoke((Object)issue, new Object[0]);
                if (obj instanceof Object[]) {
                    obj = this.arrayToStr((Object[])obj);
                }
                System.out.println(obj);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private String arrayToStr(Object[] o) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < o.length; ++i) {
            sb.append(o[i]).append(" ");
        }
        return sb.toString();
    }

    private byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length < Integer.MAX_VALUE) {
            int offset;
            int numRead;
            byte[] bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
            return bytes;
        }
        System.out.println("File is too large");
        return null;
    }

    private static class Timing {
        private String operationDesc;
        private long then;

        private Timing(String operationDesc) {
            this.operationDesc = operationDesc;
            this.then = System.currentTimeMillis();
        }

        private static Timing startTiming(String operationDesc) {
            System.out.println("\nRunning : " + operationDesc);
            return new Timing(operationDesc);
        }

        private void printTiming() {
            long howLong = System.currentTimeMillis() - this.then;
            System.out.println("________________________________________________________________");
            DecimalFormat decFormat = new DecimalFormat("###,##0");
            System.out.println("\t" + this.operationDesc + " took " + decFormat.format(howLong) + " ms to run");
        }
    }
}

