/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import java.util.Arrays;
import java.util.Iterator;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyPackageDoc;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.codehaus.groovy.tools.groovydoc.GroovyDocTemplateEngine;
import org.codehaus.groovy.tools.groovydoc.GroovyDocTool;
import org.codehaus.groovy.tools.groovydoc.OutputTool;

public class GroovyDocWriter {
    private GroovyDocTool tool;
    private OutputTool output;
    private GroovyDocTemplateEngine templateEngine;
    private static final String FS = "/";

    public GroovyDocWriter(GroovyDocTool tool, OutputTool output, GroovyDocTemplateEngine templateEngine) {
        this.tool = tool;
        this.output = output;
        this.templateEngine = templateEngine;
    }

    public void writeClasses(GroovyRootDoc rootDoc, String destdir) throws Exception {
        for (GroovyClassDoc classDoc : Arrays.asList(rootDoc.classes())) {
            this.writeClassToOutput(classDoc, destdir);
        }
    }

    public void writeClassToOutput(GroovyClassDoc classDoc, String destdir) throws Exception {
        String destFileName = destdir + FS + classDoc.getFullPathName() + ".html";
        System.out.println("Generating " + destFileName);
        String renderedSrc = this.templateEngine.applyClassTemplates(classDoc);
        this.output.writeToOutput(destFileName, renderedSrc);
    }

    public void writePackages(GroovyRootDoc rootDoc, String destdir) throws Exception {
        for (GroovyPackageDoc packageDoc : Arrays.asList(rootDoc.specifiedPackages())) {
            this.output.makeOutputArea(destdir + FS + packageDoc.name());
            this.writePackageToOutput(packageDoc, destdir);
        }
    }

    public void writePackageToOutput(GroovyPackageDoc packageDoc, String destdir) throws Exception {
        Iterator<String> templates = this.templateEngine.packageTemplatesIterator();
        while (templates.hasNext()) {
            String template = templates.next();
            String renderedSrc = this.templateEngine.applyPackageTemplate(template, packageDoc);
            String destFileName = destdir + FS + packageDoc.name() + FS + this.tool.getFile(template);
            System.out.println("Generating " + destFileName);
            this.output.writeToOutput(destFileName, renderedSrc);
        }
    }

    public void writeRoot(GroovyRootDoc rootDoc, String destdir) throws Exception {
        this.output.makeOutputArea(destdir);
        this.writeRootDocToOutput(rootDoc, destdir);
    }

    public void writeRootDocToOutput(GroovyRootDoc rootDoc, String destdir) throws Exception {
        Iterator<String> templates = this.templateEngine.docTemplatesIterator();
        while (templates.hasNext()) {
            String template = templates.next();
            String destFileName = destdir + FS + this.tool.getFile(template);
            System.out.println("Generating " + destFileName);
            if (this.hasBinaryExtension(template)) {
                this.templateEngine.copyBinaryResource(template, destFileName);
                continue;
            }
            String renderedSrc = this.templateEngine.applyRootDocTemplate(template, rootDoc);
            this.output.writeToOutput(destFileName, renderedSrc);
        }
    }

    private boolean hasBinaryExtension(String template) {
        return template.endsWith(".gif");
    }
}

