/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;

public final class CurriedClosure
extends Closure {
    private Object[] curriedParams;
    private int index;

    public CurriedClosure(int index, Closure uncurriedClosure, Object[] arguments) {
        super(uncurriedClosure.clone());
        this.curriedParams = arguments;
        this.index = index;
        int origMaxLen = uncurriedClosure.getMaximumNumberOfParameters();
        this.maximumNumberOfParameters = origMaxLen - arguments.length;
        if (index < 0) {
            if (index < -origMaxLen || index > -arguments.length) {
                throw new IllegalArgumentException("To curry " + arguments.length + " argument(s) expect index range " + -origMaxLen + ".." + -arguments.length + " but found " + index);
            }
            this.index += origMaxLen;
        } else if (index > this.maximumNumberOfParameters) {
            throw new IllegalArgumentException("To curry " + arguments.length + " argument(s) expect index range 0.." + this.maximumNumberOfParameters + " but found " + index);
        }
    }

    public CurriedClosure(Closure uncurriedClosure, Object[] arguments) {
        this(0, uncurriedClosure, arguments);
    }

    @Deprecated
    public CurriedClosure(Closure uncurriedClosure, int i) {
        this(uncurriedClosure, new Object[]{i});
    }

    public Object[] getUncurriedArguments(Object[] arguments) {
        Object[] newCurriedParams = new Object[this.curriedParams.length + arguments.length];
        System.arraycopy(arguments, 0, newCurriedParams, 0, this.index);
        System.arraycopy(this.curriedParams, 0, newCurriedParams, this.index, this.curriedParams.length);
        if (arguments.length - this.index > 0) {
            System.arraycopy(arguments, this.index, newCurriedParams, this.curriedParams.length + this.index, arguments.length - this.index);
        }
        return newCurriedParams;
    }

    public void setDelegate(Object delegate) {
        ((Closure)this.getOwner()).setDelegate(delegate);
    }

    public Object getDelegate() {
        return ((Closure)this.getOwner()).getDelegate();
    }

    public void setResolveStrategy(int resolveStrategy) {
        ((Closure)this.getOwner()).setResolveStrategy(resolveStrategy);
    }

    public int getResolveStrategy() {
        return ((Closure)this.getOwner()).getResolveStrategy();
    }

    public Object clone() {
        Closure uncurriedClosure = (Closure)((Closure)this.getOwner()).clone();
        return new CurriedClosure(this.index, uncurriedClosure, this.curriedParams);
    }

    public Class[] getParameterTypes() {
        Class[] oldParams = ((Closure)this.getOwner()).getParameterTypes();
        Class[] newParams = new Class[oldParams.length - this.curriedParams.length];
        System.arraycopy(oldParams, 0, newParams, 0, this.index);
        if (newParams.length - this.index > 0) {
            System.arraycopy(oldParams, this.curriedParams.length + this.index, newParams, this.index, newParams.length - this.index);
        }
        return newParams;
    }
}

