/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.scm.ScmException;
import org.codehaus.mojo.build.AbstractScmMojo;
import org.codehaus.mojo.build.OutputFormat;
import org.codehaus.mojo.build.Utils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="create-metadata", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true, threadSafe=true, aggregator=true)
public class CreateMetadataMojo
extends AbstractScmMojo {
    @Parameter(defaultValue="${project.name}")
    private String applicationName;
    @Parameter(defaultValue="name")
    private String applicationPropertyName;
    @Parameter(defaultValue="version")
    private String versionPropertyName;
    @Parameter(defaultValue="${project.version}")
    private String version;
    @Parameter(defaultValue="revision")
    private String revisionPropertyName;
    @Parameter(defaultValue="timestamp")
    private String timestampPropertyName;
    @Parameter(property="maven.build.timestamp.format")
    private String timestampFormat;
    @Parameter(property="maven.buildNumber.timestampTimeZone", defaultValue="")
    private String timezone;
    @Parameter(defaultValue="${project.build.directory}/generated/build-metadata", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="build.properties", required=true)
    private String outputName;
    @Parameter(defaultValue="false")
    private boolean addOutputDirectoryToResources;
    @Parameter(defaultValue="false")
    private boolean attach;
    @Parameter(defaultValue="build")
    private String classifier;
    @Parameter
    private List<File> outputFiles = new ArrayList<File>();
    @Parameter
    private Map<String, String> properties = new HashMap<String, String>();
    @Parameter(defaultValue="false")
    private boolean autoDetectOutputFormat;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        Properties props = new Properties();
        props.put(this.applicationPropertyName, this.applicationName);
        props.put(this.versionPropertyName, this.version);
        props.put(this.timestampPropertyName, Utils.createTimestamp(this.timestampFormat, this.timezone));
        props.put(this.revisionPropertyName, this.getRevision());
        this.properties.entrySet().forEach(entry -> props.put(entry.getKey(), entry.getValue()));
        File outputFile = new File(this.outputDirectory, this.outputName);
        this.outputFiles.add(outputFile);
        for (File file : this.outputFiles) {
            file.getParentFile().mkdirs();
            this.writeToFile(props, file);
        }
        if (this.attach) {
            this.projectHelper.attachArtifact(this.project, "properties", this.classifier, outputFile);
        }
        if (this.addOutputDirectoryToResources) {
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            this.project.addResource(resource);
        }
    }

    private void writeToFile(Properties props, File file) throws MojoFailureException {
        try {
            if (this.autoDetectOutputFormat) {
                OutputFormat outputFormat = OutputFormat.getOutputFormatFor(file.getName());
                this.writeToFile(props, file, outputFormat);
            } else {
                this.writeToFile(props, file, OutputFormat.DEFAULT_FORMAT);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to store output to " + file, (Throwable)e);
        }
    }

    private void writeToFile(Properties props, File file, OutputFormat outputFormat) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            outputFormat.write(props, out);
        }
    }

    public String getRevision() throws MojoExecutionException {
        try {
            return this.getScmRevision();
        }
        catch (ScmException e) {
            if (!StringUtils.isEmpty((String)this.revisionOnScmFailure)) {
                this.getLog().warn((CharSequence)("Cannot get the revision information from the scm repository, proceeding with revision of " + this.revisionOnScmFailure + " : \n" + e.getLocalizedMessage()));
                return this.revisionOnScmFailure;
            }
            throw new MojoExecutionException("Cannot get the revision information from the scm repository : \n" + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }
}

