/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;

public class Dependencies {
    private final Map<String, Dependency> key2DependencyMap = new HashMap<String, Dependency>();

    protected String getKey(Dependency dependency) {
        return dependency.getManagementKey() + ":" + dependency.getClassifier();
    }

    public void addAll(List<Dependency> dependencies) {
        dependencies.forEach(this::add);
    }

    public void add(Dependency dependency) {
        String key = this.getKey(dependency);
        Dependency replaced = this.key2DependencyMap.put(key, dependency);
        if (replaced != null) {
            throw new IllegalStateException("Duplicate dependency! Original: " + this.getKey(replaced) + " duplicate: " + this.getKey(dependency));
        }
    }

    public boolean contains(Dependency dependency) {
        return this.key2DependencyMap.containsKey(this.getKey(dependency));
    }

    public Dependency resolve(Dependency dependency) {
        return this.key2DependencyMap.get(this.getKey(dependency));
    }

    public List<Dependency> toList() {
        ArrayList<Dependency> result = new ArrayList<Dependency>(this.key2DependencyMap.values());
        return result;
    }
}

