/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.util.Optional;
import org.apache.maven.model.Dependency;

public class DependencyBuilder {
    private Optional<String> groupId = Optional.empty();
    private Optional<String> artifactId = Optional.empty();
    private Optional<String> version = Optional.empty();
    private Optional<String> type = Optional.empty();
    private Optional<String> classifier = Optional.empty();
    private Optional<String> scope = Optional.empty();
    private Optional<String> optional = Optional.empty();

    private DependencyBuilder() {
    }

    public DependencyBuilder withGroupId(String groupId) {
        this.groupId = Optional.ofNullable(groupId);
        return this;
    }

    public DependencyBuilder withArtifactId(String artifactId) {
        this.artifactId = Optional.ofNullable(artifactId);
        return this;
    }

    public DependencyBuilder withVersion(String version) {
        this.version = Optional.ofNullable(version);
        return this;
    }

    public DependencyBuilder withType(String type) {
        this.type = Optional.ofNullable(type);
        return this;
    }

    public DependencyBuilder withClassifier(String classifier) {
        this.classifier = Optional.ofNullable(classifier);
        return this;
    }

    public DependencyBuilder withScope(String scope) {
        this.scope = Optional.ofNullable(scope);
        return this;
    }

    public DependencyBuilder withOptional(String optional) {
        this.optional = Optional.ofNullable(optional);
        return this;
    }

    public DependencyBuilder withOptional(boolean optional) {
        this.optional = Optional.of(String.valueOf(optional));
        return this;
    }

    public static DependencyBuilder newBuilder() {
        return new DependencyBuilder();
    }

    @Deprecated
    public static Dependency dependencyWith(String groupId, String artifactId, String version) {
        return DependencyBuilder.newBuilder().withGroupId(groupId).withArtifactId(artifactId).withVersion(version).build();
    }

    @Deprecated
    public static Dependency dependencyWith(String groupId, String artifactId, String version, String type, String classifier, String scope) {
        return DependencyBuilder.newBuilder().withGroupId(groupId).withArtifactId(artifactId).withVersion(version).withType(type).withClassifier(classifier).withScope(scope).build();
    }

    public Dependency build() {
        Dependency inst = new Dependency();
        this.groupId.ifPresent(arg_0 -> ((Dependency)inst).setGroupId(arg_0));
        this.artifactId.ifPresent(arg_0 -> ((Dependency)inst).setArtifactId(arg_0));
        this.version.ifPresent(arg_0 -> ((Dependency)inst).setVersion(arg_0));
        this.type.ifPresent(arg_0 -> ((Dependency)inst).setType(arg_0));
        this.classifier.ifPresent(arg_0 -> ((Dependency)inst).setClassifier(arg_0));
        this.scope.ifPresent(arg_0 -> ((Dependency)inst).setScope(arg_0));
        this.optional.ifPresent(arg_0 -> ((Dependency)inst).setOptional(arg_0));
        return inst;
    }
}

