/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.gwt.rpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ModelService;
import org.eaglei.model.gwt.rpc.ModelServiceAsync;

public class ClientModelManager {
    public static final ClientModelManager INSTANCE = new ClientModelManager();
    private static final ModelServiceAsync modelService = (ModelServiceAsync)GWT.create(ModelService.class);
    private List<EIEntity> listInstitutions = null;
    private List<EIClass> listTopLevelClasses = null;
    private List<EIClass> listNonResourceClasses = null;
    private final HashMap<EIURI, EIClass> mapIdToClass = new HashMap();

    private ClientModelManager() {
    }

    public void getInstitutions(final InstitutionsCallback callback) {
        if (this.listInstitutions != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(ClientModelManager.this.listInstitutions);
                }
            });
        } else {
            modelService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIEntity> result) {
                    ClientModelManager.this.listInstitutions = result;
                    callback.onSuccess(ClientModelManager.this.listInstitutions);
                }
            });
        }
    }

    public void getTopLevelClasses(final TopLevelClassesCallback callback) {
        if (this.listTopLevelClasses != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(ClientModelManager.this.listTopLevelClasses);
                }
            });
        } else {
            modelService.getTopLevelClasses(new AsyncCallback<List<EIClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIClass> result) {
                    ArrayList<EIClass> cacheResults = new ArrayList<EIClass>(result.size());
                    for (EIClass c : result) {
                        cacheResults.add(ClientModelManager.this.getCached(c));
                    }
                    ClientModelManager.this.listTopLevelClasses = cacheResults;
                    callback.onSuccess(ClientModelManager.this.listTopLevelClasses);
                }
            });
        }
    }

    public void getNonResourceClasses(final NonResourceBaseClassesCallback callback) {
        if (this.listNonResourceClasses != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(ClientModelManager.this.listNonResourceClasses);
                }
            });
        } else {
            modelService.getNonResourceBaseClasses(new AsyncCallback<List<EIClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIClass> result) {
                    ArrayList<EIClass> cacheResults = new ArrayList<EIClass>(result.size());
                    for (EIClass c : result) {
                        cacheResults.add(ClientModelManager.this.getCached(c));
                    }
                    ClientModelManager.this.listNonResourceClasses = cacheResults;
                    callback.onSuccess(ClientModelManager.this.listNonResourceClasses);
                }
            });
        }
    }

    public void getClass(final EIURI id, final ClassCallback callback) {
        if (this.mapIdToClass.containsKey(id)) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess((EIClass)ClientModelManager.this.mapIdToClass.get(id));
                }
            });
        } else {
            modelService.getClass(id, new AsyncCallback<EIClass>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(EIClass result) {
                    callback.onSuccess(ClientModelManager.this.getCached(result));
                }
            });
        }
    }

    public void getSubClasses(final EIClass resource, final SubClassCallback callback) {
        if (!resource.hasSubClass() || resource.getSubClasses() != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(resource);
                }
            });
        } else {
            modelService.getSubClasses(resource.getEntity().getURI(), new AsyncCallback<List<EIClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIClass> result) {
                    ArrayList<EIClass> cacheResults = new ArrayList<EIClass>(result.size());
                    for (EIClass c : result) {
                        cacheResults.add(ClientModelManager.this.getCached(c));
                    }
                    resource.setSubClasses(cacheResults);
                    callback.onSuccess(resource);
                }
            });
        }
    }

    public void getSuperClasses(EIURI resourceURI, final SuperClassesCallback callback) {
        EIClass resourceClass = this.mapIdToClass.get(resourceURI);
        if (resourceClass != null) {
            this.getSuperClasses(resourceClass, callback);
        } else {
            this.getClass(resourceURI, new ClassCallback(){

                @Override
                public void onSuccess(EIClass result) {
                    ClientModelManager.this.getSuperClasses(ClientModelManager.this.getCached(result), callback);
                }
            });
        }
    }

    public void getSuperClasses(final EIClass resource, final SuperClassesCallback callback) {
        EIClass needsSuperClass = resource;
        while (needsSuperClass != null) {
            if (!needsSuperClass.hasSuperClass()) {
                needsSuperClass = null;
                continue;
            }
            if (needsSuperClass.getSuperClass() == null) break;
            needsSuperClass = needsSuperClass.getSuperClass();
        }
        if (needsSuperClass == null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(resource);
                }
            });
        } else {
            final EIClass targetClass = needsSuperClass;
            modelService.getSuperClasses(targetClass.getEntity().getURI(), new AsyncCallback<List<EIClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIClass> result) {
                    EIClass cacheChild = targetClass;
                    for (EIClass parent : result) {
                        EIClass cacheParent = ClientModelManager.this.getCached(parent);
                        cacheChild.setSuperClass(cacheParent);
                        cacheChild = cacheParent;
                    }
                    callback.onSuccess(resource);
                }
            });
        }
    }

    public void getProperties(final EIClass resource, final PropertyCallback callback) {
        if (!resource.hasProperty() || resource.getProperties() != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(resource);
                }
            });
        } else {
            modelService.getProperties(resource.getEntity().getURI(), new AsyncCallback<List<EIProperty>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIProperty> result) {
                    resource.setProperties(ClientModelManager.this.getCached(result));
                    callback.onSuccess(resource);
                }
            });
        }
    }

    public void getClassDefinitions(final List<EIClass> classList, final ClassDefinitionCallback callback) {
        ArrayList<EIURI> classURIList = new ArrayList<EIURI>(classList.size());
        for (EIClass clazz : classList) {
            classURIList.add(clazz.getEntity().getURI());
        }
        modelService.getClassDefinitions(classURIList, new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<String> result) {
                int index = 0;
                for (EIClass clazz : classList) {
                    clazz.setDefinition(result.get(index++));
                }
                callback.onSuccess(classList);
            }
        });
    }

    public void getLabels(final EIURI uri, final LabelsCallback callback) {
        modelService.getLabels(uri, new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<String> result) {
                callback.onSuccess(uri, result);
            }
        });
    }

    private List<EIProperty> getCached(List<EIProperty> propList) {
        for (EIProperty p : propList) {
            EIObjectProperty op;
            EIClass c;
            if (!(p instanceof EIObjectProperty) || (c = (op = (EIObjectProperty)p).getRange()) == null) continue;
            op.setRange(this.getCached(c));
        }
        return propList;
    }

    private EIClass getCached(EIClass c) {
        if (this.mapIdToClass.containsKey(c.getEntity().getURI())) {
            return this.mapIdToClass.get(c.getEntity().getURI());
        }
        this.mapIdToClass.put(c.getEntity().getURI(), c);
        return c;
    }

    public static interface LabelsCallback {
        public void onSuccess(EIURI var1, List<String> var2);
    }

    public static interface ClassDefinitionCallback {
        public void onSuccess(List<EIClass> var1);
    }

    public static interface PropertyCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface SuperClassesCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface SubClassCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface ClassCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface NonResourceBaseClassesCallback {
        public void onSuccess(List<EIClass> var1);
    }

    public static interface TopLevelClassesCallback {
        public void onSuccess(List<EIClass> var1);
    }

    public static interface InstitutionsCallback {
        public void onSuccess(List<EIEntity> var1);
    }
}

