/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.gwt.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.model.gwt.rpc.ModelService;
import org.eaglei.model.jena.JenaEIOntModel;

public class ModelServlet
extends RemoteServiceServlet
implements ModelService {
    protected static final Log logger = LogFactory.getLog(ModelServlet.class);
    private EIOntModel model;

    public void init() throws ServletException {
        this.model = JenaEIOntModel.INSTANCE;
    }

    @Override
    public List<EIEntity> getInstitutions() throws LoggedException {
        try {
            return this.model.getInstitutions();
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getTopLevelClasses: ", t);
            throw new LoggedException();
        }
    }

    @Override
    public List<EIClass> getTopLevelClasses() throws LoggedException {
        try {
            return this.model.getTopLevelClasses();
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getTopLevelClasses: ", t);
            throw new LoggedException();
        }
    }

    @Override
    public List<EIClass> getNonResourceBaseClasses() throws LoggedException {
        try {
            return this.model.getNonResourceBaseClasses();
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getNonResourceClasses: ", t);
            throw new LoggedException();
        }
    }

    @Override
    public EIClass getClass(EIURI classId) throws LoggedException {
        try {
            return this.model.getClass(classId);
        }
        catch (Throwable t) {
            logger.error((Object)("Error in getClass: " + classId), t);
            throw new LoggedException();
        }
    }

    @Override
    public List<EIClass> getSuperClasses(EIURI classId) throws LoggedException {
        try {
            ArrayList<EIClass> result = new ArrayList<EIClass>();
            EIClass childClass = this.model.getClass(classId);
            while (childClass.hasSuperClass()) {
                EIClass parentClass = this.model.getSuperClass(childClass);
                assert (parentClass != null);
                result.add(parentClass);
                childClass = parentClass;
            }
            return result;
        }
        catch (Throwable t) {
            logger.error((Object)("Error in getSuperClasses: " + classId), t);
            throw new LoggedException();
        }
    }

    @Override
    public List<EIClass> getSubClasses(EIURI classId) throws LoggedException {
        try {
            return this.model.getSubClasses(classId);
        }
        catch (Throwable t) {
            logger.error((Object)("Error in getSubClasses: " + classId), t);
            throw new LoggedException();
        }
    }

    @Override
    public List<EIProperty> getProperties(EIURI classId) throws LoggedException {
        try {
            List listProperties = this.model.getProperties(classId);
            return listProperties;
        }
        catch (Throwable t) {
            logger.error((Object)("Error in getProperties: " + classId), t);
            throw new LoggedException();
        }
    }

    @Override
    public List<String> getClassDefinitions(List<EIURI> classURIs) throws LoggedException {
        try {
            return this.model.getClassDefinitions(classURIs);
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getClassDefinitions: ", t);
            throw new LoggedException();
        }
    }

    @Override
    public List<String> getLabels(EIURI uri) throws LoggedException {
        try {
            return this.model.getLabels(uri);
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getLabels: ", t);
            throw new LoggedException();
        }
    }
}

