package org.eaglei.suggest.provider;

import java.io.IOException;
import java.util.List;

/**
 * Interface for classes the implement auto-suggest functionality.
 * 
 * @author rfrost
 */
public interface SuggestionProvider {

    /**
     * Initializes or updates the auto-suggest index.
     * @param source Source of suggestions. Cannot be null.
     * @throws IOException Thrown if an error is encountered creating or updating the index.
     */
    public void index(SuggestionSource source) throws IOException;

    /**
     * Retrieves suggestions for the specified query.
     * @param query Query string. Not null.
     * @param maxSuggestions Maximum number of suggestions to generate.
     * @return List of generated suggestions in relevance ranked order.
     * @throws IOException Thrown if an error is encountered generating the suggestions.
     */
    public List<Suggestion> getSuggestions(String query, int maxSuggestions) throws IOException;

}
