package org.eaglei.suggest.provider.model.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.lucene.analysis.Analyzer;
import org.eaglei.common.lexical.EntityMatch;
import org.eaglei.common.lexical.model.ModelEntityExtractor;
import org.eaglei.suggest.provider.Suggestion;
import org.eaglei.suggest.provider.SuggestionProvider;
import org.eaglei.suggest.provider.SuggestionSource;
import org.eaglei.suggest.provider.lucene.AutoSuggestIndexAnalyzer;
import org.eaglei.suggest.provider.lucene.AutoSuggestQueryAnalyzer;

/**
 * Implementation of SuggestionProvider based on ModelEntityExtractor.
 * 
 * TODO support index update
 * 
 * @author rfrost
 */
public class ModelSuggestionProvider implements SuggestionProvider {

	private ModelEntityExtractor extractor;
	
	public ModelSuggestionProvider() {
	}
	
    /* (non-Javadoc)
     * @see org.eaglei.suggest.provider.SuggestionProvider#index(org.eaglei.suggest.provider.SuggestionSource)
     */
    public void index(final SuggestionSource source) throws IOException {
		assert source != null;
		assert source instanceof ModelSuggestionSource;
		final ModelSuggestionSource modelSource = (ModelSuggestionSource) source;
    	final Analyzer queryAnalyzer = new AutoSuggestQueryAnalyzer();
    	final Analyzer indexAnalyzer = new AutoSuggestIndexAnalyzer();
    	this.extractor = new ModelEntityExtractor(queryAnalyzer, 
    			indexAnalyzer, modelSource.getEntitySource()); 
    }

    /* (non-Javadoc)
     * @see org.eaglei.suggest.provider.SuggestionProvider#getSuggestions(java.lang.String, int)
     */
    public List<Suggestion> getSuggestions(final String query, final int maxSuggestions) throws IOException {
		final List<EntityMatch> matches = this.extractor.match(query, maxSuggestions);
		final List<Suggestion> suggestions = new ArrayList<Suggestion>(matches.size());
		for (EntityMatch match: matches) {
			final Suggestion suggestion = new Suggestion(match.getHighlight(), match.getMatchLabel(), match.getEntity().getURI().toString());
			suggestions.add(suggestion);
		}
		return suggestions;
	}
}
