package org.eaglei.suggest.provider.model.poc;

import org.eaglei.suggest.provider.Suggestion;

/**
 * Output of SuggestionProviders.
 * Helps optimize the optimize generation of html suggest strings
 * @author @tbashor
 */
public final class POCSuggestion extends Suggestion implements Comparable<POCSuggestion> {

	private String endSeq;
	
    public POCSuggestion(final String query, final String text, final String strURI, final int startIndex, final int endIndex) {
        super(getDisplayString(text, query, startIndex, endIndex), text, strURI);
        this.endSeq = text.substring(startIndex);
    }
    
    private static String getDisplayString(final String text, final String query, final int startIndex, final int endIndex) {
        String startSeg = text.substring(0, startIndex) + "<b>"; 
        String endSeg = text.substring(startIndex);
    	StringBuilder sb = new StringBuilder();
        sb.append(startSeg);
        sb.append(query);
        sb.append("</b>");
        sb.append(endSeg.substring(query.length()));
        return sb.toString();
    }
    
    @Override
    public int compareTo(POCSuggestion o) {
        // Sort first by the end segment.
        // if end segments are same, sort by full label
        int result = this.endSeq.compareTo(o.endSeq);
        return (result != 0) ? result : getReplacementText().compareTo(o.getReplacementText());
    }
}

