/**
 * 
 */
package org.eaglei.datatools.jena;

import java.util.Map;

import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

/**
 * @author sc281
 * 
 */
public class User {

	private String					label;
	private EIURI					userURI;
	private EIInstance				userInstance;
	private Map<Workspace, Role>	haveAccessToWorkspaces;
	private String 					sessionId;

	public User(EIURI userURI) {
		//call the repository API to fill all the variables 
		setLabel("");
		setUserURI(userURI);
		setUserInstance(null);
		setHaveAccessToWorkspaces(null);
	}

	public User() {
		super();
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public EIURI getUserURI() {
		return userURI;
	}

	public void setUserURI(EIURI userURI) {
		this.userURI = userURI;
	}

	public EIInstance getUserInstance() {
		return userInstance;
	}

	public void setUserInstance(EIInstance userInstance) {
		this.userInstance = userInstance;
	}

	public Map<Workspace, Role> getHaveAccessToWorkspaces() {
		return haveAccessToWorkspaces;
	}

	public void setHaveAccessToWorkspaces(Map<Workspace, Role> haveAccessToWorkspaces) {
		this.haveAccessToWorkspaces = haveAccessToWorkspaces;
	}

	
	public String getSessionId() {
		return sessionId;
	}

	
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	@Override
	public String toString() {

		return userURI.toString();
	}

}
