package org.eaglei.datatools.provider;

import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;


public interface RepositoryProvider  {

    /*
     * EIInstance functionality
     */

	//FIXME these granular, query-oriented methods should be moved elsewhere
    
    //Should favor EIQuery over the specific methods
    public List<EIInstanceMinimal> EIQuery(String session, String sparql) throws Exception;
    
    // CRUD, etc
    public List<EIURI> getNewInstanceID(String session, int count) throws Exception;
    public EIInstance getEmptyEIInstance(String session, EIURI classUri, EIEntity instanceEntity) throws Exception; 
    public EIInstance getEmptyEIInstance(String session, EIURI classUri) throws Exception;
    public EIInstance getInstance(String session, EIURI instanceID) throws Exception;
    public String updateInstance(String session, EIInstance instance, String token) throws Exception ;;
    public void createInstance(String session, EIInstance instance) throws Exception ;;
    public EIInstance deepCopy(String session, EIURI originalUri) throws Exception ;
  
    public void deleteInstance(String session, EIURI instanceUri) throws Exception ;;

    public String retrieveLabel(String session, EIURI uri) throws Exception;   
    public Map<EIEntity,String> retrieveLabels(String session, List<EIEntity> entities) throws Exception;
    public Map<EIURI, String> retrieveUriLabels(String session, List<EIURI> uris) throws Exception;

    /*
     * Bulk upload
     */
    
    @Deprecated
    //Bulk upload is discouraged because metadata is not appropriately created
    public void uploadInstances(String session, String rdf) throws Exception;
    
    /*
     *  free from SPARQL query to this provider
     */
    
    
    public String query(String session, String sparql) throws Exception;
    
    /*
    * login/logout etc
    */
    
   public String[] login(String user, String password) throws Exception;    
   public void logout(String session) throws Exception;
   public String[] whoami(String session) throws Exception;
   public boolean isOnline();
   
   /*
    * workflow fake REST API
    */
   
   //public String getWorflowState(String session, String uri) throws Exception; // Maybe?  Return type?
   public String promote(String session, EIURI uri, EIURI newState) throws Exception; // or is it String[]?
   public String claim(String session, EIURI uri, String claimant) throws Exception; // or is it String[]?
  
   //Queries
   public List<EIInstanceMinimal> getFilterQuery(String session, String user, 
		   EIURI classUri, EIURI state, EIURI lab) throws Exception;
   public List<EIInstanceMinimal> getFilterQuery(String session, String user,
			EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter)
			throws Exception;

   public String[] getWFStates(String session, String user) throws Exception;


}