/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Properties;

public class DatatoolsConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Properties config = new Properties();

    public DatatoolsConfiguration(File propFile) throws IOException {
        this(new FileReader(propFile));
    }

    public DatatoolsConfiguration(Reader propFileContents) throws IOException {
        this.config.load(propFileContents);
    }

    public String getDatatoolsRepositoryProviderFactory() {
        return this.config.getProperty(Props.RepositoryProviderFactory.propKey);
    }

    public String getDefaultUser() {
        return this.config.getProperty(Props.RepositoryUser.propKey);
    }

    public String getDefaultPassword() {
        return this.config.getProperty(Props.RepositoryPassword.propKey);
    }

    public String getDatatoolsRepositoryURL() {
        return this.config.getProperty(Props.RepositoryNetworkURL.propKey);
    }

    public String getDatatoolsRepositoryNamespace() {
        return this.config.getProperty(Props.RepositoryNamespace.propKey);
    }

    public String getDatatoolsMemoryFile() {
        return this.config.getProperty(Props.RepositoryMemoryFile.propKey);
    }

    public boolean getDatatoolsAcceptSelfSignedCerts() {
        return "true".equals(this.config.getProperty(Props.AcceptSelfSignedCerts.propKey));
    }

    public Properties getProperties() {
        return this.config;
    }

    static enum Props {
        RepositoryNetworkURL("datatools.network.url"),
        RepositoryProviderFactory("datatools.repository.provider.factory"),
        RepositoryUser("datatools.repository.user"),
        RepositoryPassword("datatools.repository.password"),
        RepositoryMemoryFile("datatools.repository.memory.rdf"),
        RepositoryNamespace("datatools.repository.namespace"),
        AcceptSelfSignedCerts("datatools.repository.provider.acceptSelfSignedCerts");

        public final String propKey;

        private Props(String propKey) {
            this.propKey = propKey;
        }
    }
}

