/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.MetadataConstants;
import org.eaglei.datatools.model.DataToolsOntConstants;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EIInstanceFactory {
    private static final Log logger = LogFactory.getLog(EIInstanceFactory.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    public static final EIInstanceFactory INSTANCE = new EIInstanceFactory();
    private static EIOntModel ontModel;

    public static EIInstanceFactory getInstance() {
        return INSTANCE;
    }

    private EIInstanceFactory() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"datatools-model-config.xml"});
        ontModel = (EIOntModel)context.getBean(EIOntModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize(EIInstance instance, String lang) {
        if (instance == null) {
            return null;
        }
        Model model = this.convertToJenaModel(instance);
        StringWriter sw = new StringWriter();
        try {
            model.write((Writer)sw, lang);
            String s = sw.toString();
            sw.flush();
            String string = s;
            return string;
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Model convertToJenaModel(EIInstance instance) {
        Property p;
        if (instance == null) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        Resource resourceInstance = model.createResource(instance.getInstanceURI().toString());
        Resource eiType = model.createResource(instance.getInstanceType().getURI().toString());
        model.add(model.createStatement(resourceInstance, RDF.type, (RDFNode)eiType));
        model.add(model.createStatement(resourceInstance, RDFS.label, instance.getInstanceLabel()));
        List otherEITypes = instance.getOtherEITypes();
        if (otherEITypes != null) {
            for (EIEntity t : otherEITypes) {
                Resource typeResource = model.createResource(t.getURI().toString());
                model.add(model.createStatement(resourceInstance, RDF.type, (RDFNode)typeResource));
            }
        }
        Map dataProps = instance.getDatatypeProperties();
        Map objectProps = instance.getObjectProperties();
        Map literalProps = instance.getNonOntologyLiteralProperties();
        Map resourceProps = instance.getNonOntologyResourceProperties();
        Map roResourceProps = instance.getReadOnlyResourceProperties();
        Map roLiteralProps = instance.getReadOnlyLiteralProperties();
        this.addLiteralTriples(model, resourceInstance, dataProps);
        this.addResourceTriples(model, resourceInstance, objectProps);
        this.addLiteralTriples(model, resourceInstance, literalProps);
        this.addResourceTriples(model, resourceInstance, resourceProps);
        for (Map.Entry entry : roLiteralProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            if (entry.getValue() == null || ((String)entry.getValue()).length() <= 0) continue;
            model.add(model.createStatement(resourceInstance, p, (String)entry.getValue()));
        }
        for (Map.Entry entry : roResourceProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            if (entry.getValue() == null || ((EIEntity)entry.getValue()).toString().length() <= 0) continue;
            Resource value = model.createResource(((EIEntity)entry.getValue()).getURI().toString());
            model.add(model.createStatement(resourceInstance, p, (RDFNode)value));
        }
        return model;
    }

    private void addResourceTriples(Model model, Resource resourceInstance, Map<EIEntity, Set<EIEntity>> resources) {
        for (Map.Entry<EIEntity, Set<EIEntity>> entry : resources.entrySet()) {
            Property p = model.createProperty(entry.getKey().getURI().toString());
            Set<EIEntity> values = entry.getValue();
            if (values == null) continue;
            for (EIEntity value : values) {
                if (value == null || value.toString().length() <= 0) continue;
                Resource valueResource = model.createResource(value.getURI().toString());
                model.add(model.createStatement(resourceInstance, p, (RDFNode)valueResource));
            }
        }
    }

    private void addLiteralTriples(Model model, Resource resourceInstance, Map<EIEntity, Set<String>> literals) {
        for (Map.Entry<EIEntity, Set<String>> entry : literals.entrySet()) {
            Property p = model.createProperty(entry.getKey().getURI().toString());
            Set<String> values = entry.getValue();
            for (String value : values) {
                if (value == null || value.length() <= 0) continue;
                model.add(model.createStatement(resourceInstance, p, value));
            }
        }
    }

    public EIInstance create(EIURI instanceUri, String rdf, String lang) {
        if (instanceUri == null || instanceUri.toString().length() == 0 || rdf == null || rdf.length() == 0) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)new StringReader(rdf), null, lang);
        return this.create(instanceUri, model);
    }

    public EIInstance createEmpty(EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = this.safeGetClass(typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstance ei = EIInstance.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        ei.setInstanceClass(instanceClass);
        return ei;
    }

    public EIInstanceMinimal createEmptyMinimal(EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = this.safeGetClass(typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstanceMinimal ei = EIInstanceMinimal.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        return ei;
    }

    public EIInstance create(EIURI instanceUri, Model model) {
        Resource subject = this.getInstanceSubject(instanceUri, model);
        if (subject == null) {
            return null;
        }
        List<EIClass> eiClasses = this.getInstanceClasses(model, subject);
        if (eiClasses == null || eiClasses.isEmpty()) {
            return null;
        }
        EIClass instanceClass = eiClasses.get(0);
        if (instanceClass == null) {
            return null;
        }
        eiClasses.remove(0);
        String instanceClassUri = instanceClass.getEntity().getURI().toString();
        String instanceLabel = this.getInstanceLabel(subject);
        if (instanceLabel == null) {
            return null;
        }
        if (isDebugEnabled) {
            logger.debug((Object)("Creating an instance of class: " + instanceClass.getEntity().toString() + " with URI: " + instanceUri + " and label: " + instanceLabel));
        }
        EIInstance ei = EIInstance.create((EIClass)instanceClass, (EIEntity)EIEntity.create((EIURI)instanceUri, (String)instanceLabel));
        this.setInstanceTypes(eiClasses, ei);
        StmtIterator iterator = model.listStatements(subject, null, (RDFNode)null);
        if (isDebugEnabled) {
            logger.debug((Object)("Searching for statements with subject: " + instanceUri.toString() + " of class: " + instanceClass.getEntity() + " and label: " + instanceLabel));
        }
        while (iterator.hasNext()) {
            Statement statement = iterator.nextStatement();
            Property predicate = statement.getPredicate();
            if (predicate.equals(RDFS.label)) continue;
            EIURI propertyUri = EIURI.create((String)predicate.getURI());
            RDFNode o = statement.getObject();
            if (predicate.equals(RDF.type) && o.isResource() && instanceClassUri.equals(((Resource)o).getURI()) || predicate.equals(RDF.type) && o.isResource() && this.containsUri(eiClasses, ((Resource)o).getURI())) continue;
            EIProperty p = this.getEIOntProperty(instanceClass.getEntity().getURI(), propertyUri);
            String objectLabel = null;
            if (o.isResource()) {
                objectLabel = this.getObjectLabel(o);
            }
            if (p != null) {
                this.addEIProperty(ei, p, propertyUri, o, objectLabel);
                continue;
            }
            this.addNonEIProperty(ei, predicate, propertyUri, o, objectLabel);
        }
        return ei;
    }

    private String getObjectLabel(RDFNode o) {
        Statement objectLabelStatement;
        EIClass classForObject = this.safeGetClass(EIURI.create((String)((Resource)o).getURI()));
        String objectLabel = classForObject != null ? classForObject.getEntity().getLabel() : ((objectLabelStatement = ((Resource)o).getProperty(RDFS.label)) != null ? objectLabelStatement.getLiteral().toString() : ((Resource)o).getURI().toString());
        return objectLabel;
    }

    private void setInstanceTypes(List<EIClass> eiClasses, EIInstance ei) {
        if (!eiClasses.isEmpty()) {
            ArrayList<EIEntity> eiTypes = new ArrayList<EIEntity>(eiClasses.size());
            for (EIClass c : eiClasses) {
                eiTypes.add(c.getEntity());
            }
            ei.setOtherEITypes(eiTypes);
        }
    }

    private String getInstanceLabel(Resource subject) {
        Statement labelStatement = subject.getProperty(RDFS.label);
        if (labelStatement == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"RDFS Label is not set for instance");
            }
            return null;
        }
        String instanceLabel = labelStatement.getString();
        return instanceLabel;
    }

    private List<EIClass> getInstanceClasses(Model model, Resource subject) {
        List<EIClass> eiClasses = this.getEIClasses(model, subject);
        if (eiClasses == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"No eagle-i types found in the model");
            }
            return null;
        }
        return eiClasses;
    }

    private Resource getInstanceSubject(EIURI instanceUri, Model model) {
        if (instanceUri == null || model == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"null parameters; no EIInstance was created");
            }
            return null;
        }
        Resource subject = model.getResource(instanceUri.toString());
        if (!model.contains(subject, null, (RDFNode)null)) {
            if (isDebugEnabled) {
                logger.debug((Object)"model doesn't contain subject; no EIInstance was created");
            }
            return null;
        }
        return subject;
    }

    public List<EIInstance> create(Model model) {
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EIInstance> instances = new ArrayList<EIInstance>();
        Set subjects = model.listSubjects().toSet();
        for (Resource r : subjects) {
            Model results = model.query((Selector)new SimpleSelector(r, null, (RDFNode)null));
            EIInstance ei = this.create(EIURI.create((String)r.getURI()), results);
            if (ei == null) continue;
            instances.add(ei);
        }
        return instances;
    }

    public List<EIInstanceMinimal> create(ResultSet resultSet) {
        if (resultSet == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<EIURI, EIInstanceMinimal> instances = new HashMap<EIURI, EIInstanceMinimal>();
        ArrayList<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
        while (resultSet.hasNext()) {
            EIInstanceMinimal ei;
            QuerySolution solution = resultSet.next();
            if (!solution.contains("s") || !solution.contains("t") || !solution.contains("l")) continue;
            EIURI instanceUri = this.getUriFromSolution(solution, "s");
            EIURI instanceType = this.getUriFromSolution(solution, "t");
            String label = this.getStringFromSolution(solution, "l");
            if (this.safeGetClass(instanceType) == null) continue;
            if (!instances.containsKey(instanceUri)) {
                ei = this.createEmptyMinimal(instanceType, EIEntity.create((EIURI)instanceUri, (String)label));
                instances.put(instanceUri, ei);
                instanceList.add(ei);
                if (isDebugEnabled) {
                    logger.debug((Object)("Creating new EIInstance: " + ei));
                }
            } else {
                ei = (EIInstanceMinimal)instances.get(instanceUri);
                ei.addEIType(EIEntity.create((EIURI)instanceType, (String)""));
                if (isDebugEnabled) {
                    logger.debug((Object)("Adding type: " + instanceType + " to existing EIInstance :" + ei));
                }
            }
            ei.setWFOwner(this.getEntityFromSolution(solution, "owner", "ownerName"));
            ei.setWFState(this.getEntityFromSolution(solution, "state", ""));
            ei.setCreationDate(this.getStringFromSolution(solution, "date"));
            ei.setLab(this.getEntityFromSolution(solution, "lab", "labName"));
        }
        return instanceList;
    }

    private EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create((String)solution.getResource(uriVariable).getURI());
            if ("state".equals(uriVariable)) {
                return DataToolsOntConstants.getStatusEntity((EIURI)uri);
            }
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create((EIURI)uri, (String)label);
        }
        return EIEntity.NULL_ENTITY;
    }

    private EIURI getUriFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return EIURI.create((String)solution.getResource(variable).getURI());
        }
        return EIURI.NULL_EIURI;
    }

    private String getStringFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return solution.getLiteral(variable).getString();
        }
        return "";
    }

    private EIProperty getEIOntProperty(EIURI instanceClassUri, EIURI propertyUri) {
        if (instanceClassUri == null || propertyUri == null) {
            return null;
        }
        List properties = ontModel.getProperties(instanceClassUri);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        for (EIProperty p : properties) {
            EIURI propUri = p.getEntity().getURI();
            if (!propUri.equals((Object)propertyUri)) continue;
            return p;
        }
        return null;
    }

    private List<EIClass> getEIClasses(Model model, Resource subject) {
        List typeStatements = model.listStatements(subject, RDF.type, (RDFNode)((Resource)null)).toList();
        if (typeStatements == null || typeStatements.isEmpty()) {
            return null;
        }
        ArrayList<EIClass> eiClasses = new ArrayList<EIClass>();
        for (Statement st : typeStatements) {
            Resource type = (Resource)st.getObject();
            EIURI typeUri = EIURI.create((String)type.getURI());
            EIClass eiClass = this.safeGetClass(typeUri);
            if (eiClass == null) continue;
            eiClasses.add(eiClass);
        }
        return eiClasses.isEmpty() ? null : eiClasses;
    }

    private void addEIProperty(EIInstance ei, EIProperty predicate, EIURI propertyUri, RDFNode o, String label) {
        String preferredLabel = ontModel.getPreferredLabel(propertyUri);
        EIEntity propEntity = EIEntity.create((EIURI)propertyUri, (String)preferredLabel);
        if (predicate instanceof EIDatatypeProperty) {
            if (o.isLiteral()) {
                String value = o.toString();
                if (isDebugEnabled) {
                    logger.debug((Object)("adding property: [" + propertyUri + "] with literal value : [" + value + "] "));
                }
                ei.addDatattypeProperty(propEntity, value);
            } else {
                EIEntity entity = EIEntity.create((EIURI)EIURI.create((String)((Resource)o).getURI()), (String)label);
                if (isDebugEnabled) {
                    logger.debug((Object)("property: [" + propertyUri + "] found in ontology but value is not literal; adding as non-ontology property "));
                }
                ei.addNonOntologyResourceProperty(propEntity, entity);
            }
        } else if (predicate instanceof EIObjectProperty) {
            if (o.isResource()) {
                EIEntity entity = EIEntity.create((EIURI)EIURI.create((String)((Resource)o).getURI()), (String)label);
                if (isDebugEnabled) {
                    logger.debug((Object)("adding property: [" + propertyUri + "] with object value : [" + entity + "] "));
                }
                ei.addObjectProperty(propEntity, entity);
            } else {
                if (isDebugEnabled) {
                    logger.debug((Object)("property: [" + propertyUri + "] found in ontology but value is not resource; adding as non-ontology property "));
                }
                ei.addNonOntologyLiteralProperty(propEntity, o.toString());
            }
        }
    }

    private void addNonEIProperty(EIInstance ei, Property predicate, EIURI propertyUri, RDFNode o, String label) {
        EIEntity propEntity;
        if (isDebugEnabled) {
            logger.debug((Object)("Property not found in ontology; we'll still add it: " + propertyUri));
        }
        if (MetadataConstants.readOnlyResources.containsKey(propertyUri)) {
            propEntity = MetadataConstants.readOnlyResources.get(propertyUri);
        } else if (MetadataConstants.readOnlyLiterals.containsKey(propertyUri)) {
            propEntity = MetadataConstants.readOnlyLiterals.get(propertyUri);
        } else {
            String predicateLabel = predicate.getLocalName();
            propEntity = EIEntity.create((EIURI)propertyUri, (String)predicateLabel);
        }
        if (o.isLiteral()) {
            if (MetadataConstants.readOnlyLiterals.containsKey(propertyUri)) {
                ei.setReadOnlyLiteralProperty(propEntity, o.toString());
            } else {
                ei.addNonOntologyLiteralProperty(propEntity, o.toString());
            }
        } else if (o.isResource()) {
            EIEntity entity = EIEntity.create((EIURI)EIURI.create((String)((Resource)o).getURI()), (String)label);
            if (MetadataConstants.readOnlyResources.containsKey(propertyUri)) {
                ei.setReadOnlyResourceProperty(propEntity, entity);
            } else {
                ei.addNonOntologyResourceProperty(propEntity, entity);
            }
        } else if (isDebugEnabled) {
            logger.debug((Object)("Could not add property " + propertyUri));
        }
    }

    private boolean containsUri(List<EIClass> eiClasses, String uri) {
        if (eiClasses == null || uri == null) {
            return false;
        }
        for (EIClass eiClass : eiClasses) {
            if (!uri.equalsIgnoreCase(eiClass.getEntity().getURI().toString())) continue;
            return true;
        }
        return false;
    }

    private String capitalizeFirst(String s) {
        char first = s.charAt(0);
        return Character.toUpperCase(first) + s.substring(1);
    }

    private EIClass safeGetClass(EIURI typeUri) {
        if (ontModel.isModelClassURI(typeUri.toString())) {
            return ontModel.getClass(typeUri);
        }
        return null;
    }
}

